/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.platform.PluginInfo;
import org.sonar.server.plugins.PluginUninstaller;
import org.sonar.server.plugins.ServerPluginRepository;
import org.sonar.server.plugins.edition.EditionBundledPlugins;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.server.user.UserSession;

public class UninstallAction
implements PluginsWsAction {
    private static final String PARAM_KEY = "key";
    private final ServerPluginRepository serverPluginRepository;
    private final PluginUninstaller pluginUninstaller;
    private final UserSession userSession;

    public UninstallAction(ServerPluginRepository serverPluginRepository, PluginUninstaller pluginUninstaller, UserSession userSession) {
        this.serverPluginRepository = serverPluginRepository;
        this.pluginUninstaller = pluginUninstaller;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("uninstall").setPost(true).setSince("5.2").setDescription("Uninstalls the plugin specified by its key.<br/>Requires user to be authenticated with Administer System permissions.").setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setDescription("The key identifying the plugin to uninstall").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        String key = request.mandatoryParam(PARAM_KEY);
        PluginInfo pluginInfo = this.serverPluginRepository.getPluginInfo(key);
        if (pluginInfo != null) {
            if (EditionBundledPlugins.isEditionBundled(pluginInfo)) {
                throw new IllegalArgumentException(String.format("SonarSource commercial plugin with key '%s' can only be uninstalled as part of a SonarSource edition", pluginInfo.getKey()));
            }
            this.pluginUninstaller.uninstall(key);
        }
        response.noContent();
    }
}

