/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.edition;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.FileUtils;
import org.sonar.server.platform.ServerFileSystem;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.UpdateCenter;
import org.sonar.updatecenter.common.Version;

public class EditionPluginDownloader {
    private static final Logger LOG = Loggers.get(EditionPluginDownloader.class);
    private static final String PLUGIN_EXTENSION = "jar";
    private final Path tmpDir;
    private final Path downloadDir;
    private final HttpDownloader downloader;

    public EditionPluginDownloader(HttpDownloader downloader, ServerFileSystem fileSystem) {
        this.downloadDir = fileSystem.getEditionDownloadedPluginsDir().toPath();
        this.downloader = downloader;
        this.tmpDir = this.downloadDir.resolveSibling(this.downloadDir.getFileName() + "_tmp");
    }

    public void downloadEditionPlugins(Set<String> pluginKeys, UpdateCenter updateCenter) {
        try {
            HashSet pluginsToInstall = new HashSet();
            for (String pluginKey : pluginKeys) {
                pluginsToInstall.addAll(updateCenter.findInstallablePlugins(pluginKey, Version.create((String)"")));
            }
            FileUtils.deleteDirectory((Path)this.tmpDir);
            Files.createDirectories(this.tmpDir, new FileAttribute[0]);
            for (Release r : pluginsToInstall) {
                this.download(r);
            }
            FileUtils.deleteDirectory((Path)this.downloadDir);
            Files.move(this.tmpDir, this.downloadDir, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            FileUtils.deleteQuietly((Path)this.tmpDir);
        }
    }

    protected void download(Release release) {
        try {
            LOG.info("Downloading plugin: {}", (Object)release.getArtifact().getKey());
            this.downloadRelease(release);
        }
        catch (Exception e) {
            String message = String.format("Fail to download the plugin (%s, version %s) from %s (error is : %s)", release.getArtifact().getKey(), release.getVersion().getName(), release.getDownloadUrl(), e.getMessage());
            LOG.debug(message, (Object)e);
            throw new IllegalStateException(message, e);
        }
    }

    private void downloadRelease(Release release) throws URISyntaxException, IOException {
        String url = release.getDownloadUrl();
        URI uri = new URI(url);
        if (url.startsWith("file:")) {
            File file = org.apache.commons.io.FileUtils.toFile((URL)uri.toURL());
            Files.copy(file.toPath(), this.tmpDir.resolve(file.getName()), new CopyOption[0]);
        } else {
            String filename = StringUtils.substringAfterLast((String)uri.getPath(), (String)"/");
            if (!filename.endsWith(".jar")) {
                filename = release.getKey() + "-" + release.getVersion() + "." + PLUGIN_EXTENSION;
            }
            Path targetFile = this.tmpDir.resolve(filename);
            this.downloader.download(uri, targetFile.toFile());
        }
    }
}

