/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.sonar.api.web.ServletFilter;

public class WebPagesFilter
implements Filter {
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CACHE_CONTROL_VALUE = "no-cache, no-store, must-revalidate";
    private static final String CONTEXT_PLACEHOLDER = "%WEB_CONTEXT%";
    private static final ServletFilter.UrlPattern URL_PATTERN = ServletFilter.UrlPattern.builder().excludes(ServletFilter.UrlPattern.Builder.staticResourcePatterns()).build();
    private String indexDotHtml;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String path = httpServletRequest.getRequestURI().replaceFirst(httpServletRequest.getContextPath(), "");
        if (!URL_PATTERN.matches(path)) {
            chain.doFilter(request, response);
            return;
        }
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name().toLowerCase(Locale.ENGLISH));
        httpServletResponse.setHeader(CACHE_CONTROL_HEADER, CACHE_CONTROL_VALUE);
        IOUtils.write((String)this.indexDotHtml, (OutputStream)httpServletResponse.getOutputStream(), (Charset)StandardCharsets.UTF_8);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String context = filterConfig.getServletContext().getContextPath();
        String indexFile = WebPagesFilter.readIndexFile(filterConfig.getServletContext());
        this.indexDotHtml = indexFile.replaceAll(CONTEXT_PLACEHOLDER, context);
    }

    private static String readIndexFile(ServletContext servletContext) {
        try {
            return IOUtils.toString((URL)Objects.requireNonNull(servletContext.getResource("/index.html")), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to provide index file", e);
        }
    }

    public void destroy() {
    }
}

