/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring.cluster;

import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import org.sonar.api.server.ServerSide;
import org.sonar.process.ProcessId;
import org.sonar.process.cluster.hz.DistributedAnswer;
import org.sonar.process.cluster.hz.HazelcastMember;
import org.sonar.process.cluster.hz.HazelcastMemberSelectors;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.platform.monitoring.cluster.AppNodesInfoLoader;
import org.sonar.server.platform.monitoring.cluster.NodeInfo;
import org.sonar.server.platform.monitoring.cluster.ProcessInfoProvider;

@ServerSide
public class AppNodesInfoLoaderImpl
implements AppNodesInfoLoader {
    private static final long DISTRIBUTED_TIMEOUT_MS = 15000L;
    private final HazelcastMember hzMember;

    public AppNodesInfoLoaderImpl(HazelcastMember hzMember) {
        this.hzMember = hzMember;
    }

    public AppNodesInfoLoaderImpl() {
        this(null);
    }

    @Override
    public Collection<NodeInfo> load() throws InterruptedException {
        HashMap<String, NodeInfo> nodesByName = new HashMap<String, NodeInfo>();
        MemberSelector memberSelector = HazelcastMemberSelectors.selectorForProcessIds((ProcessId[])new ProcessId[]{ProcessId.WEB_SERVER, ProcessId.COMPUTE_ENGINE});
        DistributedAnswer distributedAnswer = this.hzMember.call(ProcessInfoProvider::provide, memberSelector, 15000L);
        for (Member member : distributedAnswer.getMembers()) {
            String nodeName = member.getStringAttribute(HazelcastMember.Attribute.NODE_NAME.getKey());
            NodeInfo nodeInfo = nodesByName.computeIfAbsent(nodeName, name -> {
                NodeInfo info = new NodeInfo((String)name);
                info.setHost(member.getAddress().getHost());
                return info;
            });
            AppNodesInfoLoaderImpl.completeNodeInfo((DistributedAnswer<ProtobufSystemInfo.SystemInfo>)distributedAnswer, member, nodeInfo);
        }
        return nodesByName.values();
    }

    private static void completeNodeInfo(DistributedAnswer<ProtobufSystemInfo.SystemInfo> distributedAnswer, Member member, NodeInfo nodeInfo) {
        Optional nodeAnswer = distributedAnswer.getAnswer(member);
        Optional failure = distributedAnswer.getFailed(member);
        if (distributedAnswer.hasTimedOut(member)) {
            nodeInfo.setErrorMessage("Failed to retrieve information on time");
        } else if (failure.isPresent()) {
            nodeInfo.setErrorMessage("Failed to retrieve information: " + ((Exception)failure.get()).getMessage());
        } else if (nodeAnswer.isPresent()) {
            ((ProtobufSystemInfo.SystemInfo)nodeAnswer.get()).getSectionsList().forEach(nodeInfo::addSection);
        }
    }
}

