/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.platform.StartupMetadata;
import org.sonar.server.platform.WebServer;

@ComputeEngineSide
@ServerSide
public class StartupMetadataProvider
extends ProviderAdapter {
    private StartupMetadata cache = null;

    public StartupMetadata provide(System2 system, SonarRuntime runtime, WebServer webServer, DbClient dbClient) {
        if (this.cache == null) {
            this.cache = runtime.getSonarQubeSide() == SonarQubeSide.SERVER && webServer.isStartupLeader() ? StartupMetadataProvider.generate(system) : StartupMetadataProvider.load(dbClient);
        }
        return this.cache;
    }

    private static StartupMetadata generate(System2 system) {
        return new StartupMetadata(system.now());
    }

    private static StartupMetadata load(DbClient dbClient) {
        try (DbSession dbSession = dbClient.openSession(false);){
            String startedAt = StartupMetadataProvider.selectProperty(dbClient, dbSession, "sonar.core.startTime");
            StartupMetadata startupMetadata = new StartupMetadata(DateUtils.parseDateTime((String)startedAt).getTime());
            return startupMetadata;
        }
    }

    private static String selectProperty(DbClient dbClient, DbSession dbSession, String key) {
        PropertyDto prop = dbClient.propertiesDao().selectGlobalProperty(dbSession, key);
        Preconditions.checkState((prop != null ? 1 : 0) != 0, (String)"Property %s is missing in database", (Object[])new Object[]{key});
        Preconditions.checkState((!StringUtils.isBlank((String)prop.getValue()) ? 1 : 0) != 0, (String)"Property %s is set but empty in database", (Object[])new Object[]{key});
        return prop.getValue();
    }
}

