/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.server.ws.WsUtils;

public class WsTemplateRef {
    private final String uuid;
    private final String organization;
    private final String name;

    private WsTemplateRef(@Nullable String uuid, @Nullable String organization, @Nullable String name) {
        WsUtils.checkRequest(uuid != null ^ name != null, "Template name or template id must be provided, not both.", new Object[0]);
        this.uuid = uuid;
        this.organization = organization;
        this.name = name;
    }

    public static WsTemplateRef fromRequest(Request wsRequest) {
        String uuid = wsRequest.param("templateId");
        String organization = wsRequest.param("organization");
        String name = wsRequest.param("templateName");
        return new WsTemplateRef(uuid, organization, name);
    }

    public static WsTemplateRef newTemplateRef(@Nullable String uuid, @Nullable String organization, @Nullable String name) {
        return new WsTemplateRef(uuid, organization, name);
    }

    @CheckForNull
    public String uuid() {
        return this.uuid;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    @CheckForNull
    public String name() {
        return this.name;
    }
}

