/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.protobuf.Message;
import java.util.Date;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.core.util.Uuids;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.PermissionTemplateDtoToPermissionTemplateResponse;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsPermissions;
import org.sonarqube.ws.client.permission.CreateTemplateWsRequest;

public class CreateTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final System2 system;
    private final PermissionWsSupport wsSupport;

    public CreateTemplateAction(DbClient dbClient, UserSession userSession, System2 system, PermissionWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.system = system;
        this.wsSupport = wsSupport;
    }

    private static CreateTemplateWsRequest toCreateTemplateWsRequest(Request request) {
        return new CreateTemplateWsRequest().setName(request.mandatoryParam("name")).setDescription(request.param("description")).setProjectKeyPattern(request.param("projectKeyPattern")).setOrganization(request.param("organization"));
    }

    private static WsPermissions.CreateTemplateWsResponse buildResponse(PermissionTemplateDto permissionTemplateDto) {
        WsPermissions.PermissionTemplate permissionTemplateBuilder = PermissionTemplateDtoToPermissionTemplateResponse.toPermissionTemplateResponse(permissionTemplateDto);
        return WsPermissions.CreateTemplateWsResponse.newBuilder().setPermissionTemplate(permissionTemplateBuilder).build();
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("create_template").setDescription("Create a permission template.<br />Requires the following permission: 'Administer System'.").setResponseExample(this.getClass().getResource("create_template-example.json")).setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        action.createParam("name").setRequired(true).setDescription("Name").setExampleValue((Object)"Financial Service Permissions");
        PermissionsWsParametersBuilder.createTemplateProjectKeyPatternParameter(action);
        PermissionsWsParametersBuilder.createTemplateDescriptionParameter(action);
        PermissionsWsParametersBuilder.createOrganizationParameter(action).setSince("6.2");
    }

    public void handle(Request request, Response response) throws Exception {
        WsPermissions.CreateTemplateWsResponse createTemplateWsResponse = this.doHandle(CreateTemplateAction.toCreateTemplateWsRequest(request));
        WsUtils.writeProtobuf((Message)createTemplateWsResponse, request, response);
    }

    private WsPermissions.CreateTemplateWsResponse doHandle(CreateTemplateWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto org = this.wsSupport.findOrganization(dbSession, request.getOrganization());
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, org.getUuid());
            this.validateTemplateNameForCreation(dbSession, org, request.getName());
            PermissionRequestValidator.validateProjectPattern(request.getProjectKeyPattern());
            PermissionTemplateDto permissionTemplate = this.insertTemplate(dbSession, org, request);
            WsPermissions.CreateTemplateWsResponse createTemplateWsResponse = CreateTemplateAction.buildResponse(permissionTemplate);
            return createTemplateWsResponse;
        }
    }

    private void validateTemplateNameForCreation(DbSession dbSession, OrganizationDto org, String name) {
        PermissionRequestValidator.validateTemplateNameFormat(name);
        PermissionTemplateDto permissionTemplateWithSameName = this.dbClient.permissionTemplateDao().selectByName(dbSession, org.getUuid(), name);
        WsUtils.checkRequest(permissionTemplateWithSameName == null, String.format("A template with the name '%s' already exists (case insensitive).", name), new Object[0]);
    }

    private PermissionTemplateDto insertTemplate(DbSession dbSession, OrganizationDto org, CreateTemplateWsRequest request) {
        Date now = new Date(this.system.now());
        PermissionTemplateDto template = this.dbClient.permissionTemplateDao().insert(dbSession, new PermissionTemplateDto().setUuid(Uuids.create()).setOrganizationUuid(org.getUuid()).setName(request.getName()).setDescription(request.getDescription()).setKeyPattern(request.getProjectKeyPattern()).setCreatedAt(now).setUpdatedAt(now));
        dbSession.commit();
        return template;
    }
}

