/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.permission.AddProjectCreatorToTemplateWsRequest;

public class AddProjectCreatorToTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final UserSession userSession;
    private final System2 system;

    public AddProjectCreatorToTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, UserSession userSession, System2 system) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
        this.system = system;
    }

    private static AddProjectCreatorToTemplateWsRequest toWsRequest(Request request) {
        AddProjectCreatorToTemplateWsRequest wsRequest = AddProjectCreatorToTemplateWsRequest.builder().setPermission(request.mandatoryParam("permission")).setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName")).build();
        PermissionRequestValidator.validateProjectPermission(wsRequest.getPermission());
        return wsRequest;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_project_creator_to_template").setDescription("Add a project creator to a permission template.<br>Requires the following permission: 'Administer System'.").setSince("6.0").setPost(true).setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(AddProjectCreatorToTemplateAction.toWsRequest(request));
        response.noContent();
    }

    private void doHandle(AddProjectCreatorToTemplateWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            Optional templatePermission = this.dbClient.permissionTemplateCharacteristicDao().selectByPermissionAndTemplateId(dbSession, request.getPermission(), template.getId().longValue());
            if (templatePermission.isPresent()) {
                this.updateTemplatePermission(dbSession, (PermissionTemplateCharacteristicDto)templatePermission.get());
            } else {
                this.addTemplatePermission(dbSession, request, template);
            }
        }
    }

    private void addTemplatePermission(DbSession dbSession, AddProjectCreatorToTemplateWsRequest request, PermissionTemplateDto template) {
        long now = this.system.now();
        this.dbClient.permissionTemplateCharacteristicDao().insert(dbSession, new PermissionTemplateCharacteristicDto().setPermission(request.getPermission()).setTemplateId(template.getId().longValue()).setWithProjectCreator(true).setCreatedAt(now).setUpdatedAt(now));
        dbSession.commit();
    }

    private void updateTemplatePermission(DbSession dbSession, PermissionTemplateCharacteristicDto templatePermission) {
        PermissionTemplateCharacteristicDto targetTemplatePermission = templatePermission.setUpdatedAt(this.system.now()).setWithProjectCreator(true);
        this.dbClient.permissionTemplateCharacteristicDao().update(dbSession, targetTemplatePermission);
        dbSession.commit();
    }
}

