/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.permission.UserPermissionDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsPermissions;

public class UsersAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionWsSupport support;

    public UsersAction(DbClient dbClient, UserSession userSession, PermissionWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("users").setSince("5.2").setDescription("Lists the users with their permissions as individual users rather than through group affiliation.<br>This service defaults to global permissions, but can be limited to project permissions by providing project id or project key.<br> This service defaults to all users, but can be limited to users with a specific permission by providing the desired permission.<br>Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>").addPagingParams(20, 100).setInternal(true).setResponseExample(this.getClass().getResource("users-example.json")).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("Limit search to user names that contain the supplied string. Must have at least %d characters.<br/>When this parameter is not set, only users having at least one permission are returned.", new Object[]{3}).setExampleValue((Object)"eri");
        PermissionsWsParametersBuilder.createOrganizationParameter(action).setSince("6.2");
        PermissionsWsParametersBuilder.createPermissionParameter(action).setRequired(false);
        PermissionsWsParametersBuilder.createProjectParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto org = this.support.findOrganization(dbSession, request.param("organization"));
            Optional<ProjectId> projectId = this.support.findProjectId(dbSession, request);
            PermissionPrivilegeChecker.checkProjectAdmin(this.userSession, org.getUuid(), projectId);
            PermissionQuery query = UsersAction.buildPermissionQuery(request, org, projectId);
            List<UserDto> users = this.findUsers(dbSession, query);
            int total = this.dbClient.userPermissionDao().countUsersByQuery(dbSession, query);
            List<UserPermissionDto> userPermissions = this.findUserPermissions(dbSession, org, users, projectId);
            Paging paging = Paging.forPageIndex((int)request.mandatoryParamAsInt("p")).withPageSize(query.getPageSize()).andTotal(total);
            WsPermissions.UsersWsResponse usersWsResponse = UsersAction.buildResponse(users, userPermissions, paging);
            WsUtils.writeProtobuf((Message)usersWsResponse, request, response);
        }
    }

    private static PermissionQuery buildPermissionQuery(Request request, OrganizationDto organization, Optional<ProjectId> project) {
        String textQuery = request.param("q");
        String permission = request.param("permission");
        PermissionQuery.Builder permissionQuery = PermissionQuery.builder().setOrganizationUuid(organization.getUuid()).setPermission(permission).setPageIndex(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps"))).setSearchQuery(textQuery);
        project.ifPresent(projectId -> permissionQuery.setComponentUuid(projectId.getUuid()));
        if (permission != null) {
            if (project.isPresent()) {
                PermissionRequestValidator.validateProjectPermission(permission);
            } else {
                PermissionRequestValidator.validateGlobalPermission(permission);
            }
        }
        if (textQuery == null) {
            permissionQuery.withAtLeastOnePermission();
        } else {
            WsUtils.checkRequest(textQuery.length() >= 3, "The '%s' parameter must have at least %d characters", "q", 3);
        }
        return permissionQuery.build();
    }

    private static WsPermissions.UsersWsResponse buildResponse(List<UserDto> users, List<UserPermissionDto> userPermissions, Paging paging) {
        TreeMultimap permissionsByUserId = TreeMultimap.create();
        userPermissions.forEach(arg_0 -> UsersAction.lambda$buildResponse$1((Multimap)permissionsByUserId, arg_0));
        WsPermissions.UsersWsResponse.Builder response = WsPermissions.UsersWsResponse.newBuilder();
        users.forEach(arg_0 -> UsersAction.lambda$buildResponse$2(response, (Multimap)permissionsByUserId, arg_0));
        response.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        return response.build();
    }

    private List<UserDto> findUsers(DbSession dbSession, PermissionQuery query) {
        List orderedIds = this.dbClient.userPermissionDao().selectUserIdsByQuery(dbSession, query);
        return Ordering.explicit((List)orderedIds).onResultOf(UserDto::getId).immutableSortedCopy((Iterable)this.dbClient.userDao().selectByIds(dbSession, (Collection)orderedIds));
    }

    private List<UserPermissionDto> findUserPermissions(DbSession dbSession, OrganizationDto org, List<UserDto> users, Optional<ProjectId> project) {
        if (users.isEmpty()) {
            return Collections.emptyList();
        }
        List userIds = users.stream().map(UserDto::getId).collect(Collectors.toList());
        PermissionQuery query = PermissionQuery.builder().setOrganizationUuid(org.getUuid()).setComponentUuid((String)project.map(ProjectId::getUuid).orElse(null)).withAtLeastOnePermission().build();
        return this.dbClient.userPermissionDao().selectUserPermissionsByQuery(dbSession, query, userIds);
    }

    private static /* synthetic */ void lambda$buildResponse$2(WsPermissions.UsersWsResponse.Builder response, Multimap permissionsByUserId, UserDto user) {
        WsPermissions.User.Builder userResponse = response.addUsersBuilder().setLogin(user.getLogin()).addAllPermissions((Iterable)permissionsByUserId.get((Object)user.getId()));
        Protobuf.setNullable((Object)user.getEmail(), arg_0 -> ((WsPermissions.User.Builder)userResponse).setEmail(arg_0));
        Protobuf.setNullable((Object)user.getName(), arg_0 -> ((WsPermissions.User.Builder)userResponse).setName(arg_0));
    }

    private static /* synthetic */ void lambda$buildResponse$1(Multimap permissionsByUserId, UserPermissionDto userPermission) {
        permissionsByUserId.put((Object)userPermission.getUserId(), (Object)userPermission.getPermission());
    }
}

