/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import java.util.Collection;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.permission.GlobalPermissions;
import org.sonar.core.permission.ProjectPermissions;

public class PermissionsWsParametersBuilder {
    private static final String PERMISSION_PARAM_DESCRIPTION = String.format("Permission<ul><li>Possible values for global permissions: %s</li><li>Possible values for project permissions %s</li></ul>", GlobalPermissions.ALL_ON_ONE_LINE, ProjectPermissions.ALL_ON_ONE_LINE);
    private static final String PROJECT_PERMISSION_PARAM_DESCRIPTION = String.format("Permission<ul><li>Possible values for project permissions %s</li></ul>", ProjectPermissions.ALL_ON_ONE_LINE);

    private PermissionsWsParametersBuilder() {
    }

    public static WebService.NewParam createPermissionParameter(WebService.NewAction action) {
        return action.createParam("permission").setDescription(PERMISSION_PARAM_DESCRIPTION).setRequired(true);
    }

    public static WebService.NewParam createProjectPermissionParameter(WebService.NewAction action) {
        return action.createParam("permission").setDescription(PROJECT_PERMISSION_PARAM_DESCRIPTION).setPossibleValues((Collection)ProjectPermissions.ALL).setRequired(true);
    }

    public static void createGroupNameParameter(WebService.NewAction action) {
        action.createParam("groupName").setDescription("Group name or 'anyone' (case insensitive)").setExampleValue((Object)"sonar-administrators");
    }

    public static WebService.NewParam createOrganizationParameter(WebService.NewAction action) {
        return action.createParam("organization").setDescription("Key of organization, used when group name is set").setExampleValue((Object)"my-org").setInternal(true);
    }

    public static void createGroupIdParameter(WebService.NewAction action) {
        action.createParam("groupId").setDescription("Group id").setExampleValue((Object)"42");
    }

    public static void createProjectParameters(WebService.NewAction action) {
        PermissionsWsParametersBuilder.createProjectIdParameter(action);
        PermissionsWsParametersBuilder.createProjectKeyParameter(action);
    }

    private static void createProjectIdParameter(WebService.NewAction action) {
        action.createParam("projectId").setDescription("Project id").setExampleValue((Object)"ce4c03d6-430f-40a9-b777-ad877c00aa4d");
    }

    private static void createProjectKeyParameter(WebService.NewAction action) {
        action.createParam("projectKey").setDescription("Project key").setExampleValue((Object)"my_project");
    }

    public static void createUserLoginParameter(WebService.NewAction action) {
        action.createParam("login").setRequired(true).setDescription("User login").setExampleValue((Object)"g.hopper");
    }

    public static void createTemplateParameters(WebService.NewAction action) {
        PermissionsWsParametersBuilder.createTemplateIdParameter(action);
        PermissionsWsParametersBuilder.createOrganizationParameter(action);
        PermissionsWsParametersBuilder.createTemplateNameParameter(action);
    }

    private static void createTemplateIdParameter(WebService.NewAction action) {
        action.createParam("templateId").setDescription("Template id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
    }

    private static void createTemplateNameParameter(WebService.NewAction action) {
        action.createParam("templateName").setDescription("Template name").setExampleValue((Object)"Default Permission Template for Projects");
    }

    public static void createTemplateProjectKeyPatternParameter(WebService.NewAction action) {
        action.createParam("projectKeyPattern").setDescription("Project key pattern. Must be a valid Java regular expression").setExampleValue((Object)".*\\.finance\\..*");
    }

    public static void createTemplateDescriptionParameter(WebService.NewAction action) {
        action.createParam("description").setDescription("Description").setExampleValue((Object)"Permissions for all projects related to the financial service");
    }

    public static void createIdParameter(WebService.NewAction action) {
        action.createParam("id").setRequired(true).setDescription("Id").setExampleValue((Object)"af8cb8cc-1e78-4c4e-8c00-ee8e814009a5");
    }
}

