/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.UserId;
import org.sonar.server.permission.ws.ProjectWsRef;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.usergroups.ws.GroupIdOrAnyone;
import org.sonar.server.usergroups.ws.GroupWsRef;
import org.sonar.server.usergroups.ws.GroupWsSupport;
import org.sonar.server.ws.WsUtils;

public class PermissionWsSupport {
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final GroupWsSupport groupWsSupport;

    public PermissionWsSupport(DbClient dbClient, ComponentFinder componentFinder, GroupWsSupport groupWsSupport) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.groupWsSupport = groupWsSupport;
    }

    public OrganizationDto findOrganization(DbSession dbSession, @Nullable String organizationKey) {
        return this.groupWsSupport.findOrganizationByKey(dbSession, organizationKey);
    }

    public Optional<ProjectId> findProjectId(DbSession dbSession, Request request) {
        return this.findProject(dbSession, request).map(ProjectId::new);
    }

    public Optional<ComponentDto> findProject(DbSession dbSession, Request request) {
        String uuid = request.param("projectId");
        String key = request.param("projectKey");
        if (uuid != null || key != null) {
            ProjectWsRef ref = ProjectWsRef.newWsProjectRef(uuid, key);
            return Optional.of(this.componentFinder.getRootComponentByUuidOrKey(dbSession, ref.uuid(), ref.key()));
        }
        return Optional.empty();
    }

    public ComponentDto getRootComponentOrModule(DbSession dbSession, ProjectWsRef projectRef) {
        return this.componentFinder.getRootComponentByUuidOrKey(dbSession, projectRef.uuid(), projectRef.key());
    }

    public GroupIdOrAnyone findGroup(DbSession dbSession, Request request) {
        Integer groupId = request.paramAsInt("groupId");
        String orgKey = request.param("organization");
        String groupName = request.param("groupName");
        GroupWsRef groupRef = GroupWsRef.create(groupId, orgKey, groupName);
        return this.groupWsSupport.findGroupOrAnyone(dbSession, groupRef);
    }

    public UserId findUser(DbSession dbSession, String login) {
        UserDto dto = this.dbClient.userDao().selectActiveUserByLogin(dbSession, login);
        WsUtils.checkFound(dto, "User with login '%s' is not found'", login);
        return new UserId(dto.getId(), dto.getLogin());
    }

    public PermissionTemplateDto findTemplate(DbSession dbSession, WsTemplateRef ref) {
        if (ref.uuid() != null) {
            return WsUtils.checkFound(this.dbClient.permissionTemplateDao().selectByUuid(dbSession, ref.uuid()), "Permission template with id '%s' is not found", ref.uuid());
        }
        OrganizationDto org = this.findOrganization(dbSession, ref.getOrganization());
        return WsUtils.checkFound(this.dbClient.permissionTemplateDao().selectByName(dbSession, org.getUuid(), ref.name()), "Permission template with name '%s' is not found (case insensitive) in organization with key '%s'", ref.name(), org.getKey());
    }

    public void checkMembership(DbSession dbSession, OrganizationDto organization, UserId user) {
        Preconditions.checkArgument((boolean)this.dbClient.organizationMemberDao().select(dbSession, organization.getUuid(), user.getId()).isPresent(), (String)"User '%s' is not member of organization '%s'", (Object[])new Object[]{user.getLogin(), organization.getKey()});
    }
}

