/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.security.DefaultGroups;
import org.sonar.api.server.ServerSide;
import org.sonar.core.permission.ProjectPermissions;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.db.permission.GroupPermissionDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.permission.UserPermissionDto;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.db.permission.template.PermissionTemplateUserDto;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;
import org.sonar.server.permission.ws.template.DefaultTemplatesResolver;
import org.sonar.server.user.UserSession;

@ServerSide
public class PermissionTemplateService {
    private final DbClient dbClient;
    private final ProjectIndexers projectIndexers;
    private final UserSession userSession;
    private final DefaultTemplatesResolver defaultTemplatesResolver;

    public PermissionTemplateService(DbClient dbClient, ProjectIndexers projectIndexers, UserSession userSession, DefaultTemplatesResolver defaultTemplatesResolver) {
        this.dbClient = dbClient;
        this.projectIndexers = projectIndexers;
        this.userSession = userSession;
        this.defaultTemplatesResolver = defaultTemplatesResolver;
    }

    public boolean wouldUserHaveScanPermissionWithDefaultTemplate(DbSession dbSession, String organizationUuid, @Nullable Integer userId, String projectKey, String qualifier) {
        if (this.userSession.hasPermission(OrganizationPermission.SCAN, organizationUuid)) {
            return true;
        }
        ComponentDto dto = new ComponentDto().setOrganizationUuid(organizationUuid).setDbKey(projectKey).setQualifier(qualifier);
        PermissionTemplateDto template = this.findTemplate(dbSession, organizationUuid, dto);
        if (template == null) {
            return false;
        }
        List potentialPermissions = this.dbClient.permissionTemplateDao().selectPotentialPermissionsByUserIdAndTemplateId(dbSession, userId, template.getId().longValue());
        return potentialPermissions.contains(OrganizationPermission.SCAN.getKey());
    }

    public void applyAndCommit(DbSession dbSession, PermissionTemplateDto template, Collection<ComponentDto> projects) {
        if (projects.isEmpty()) {
            return;
        }
        for (ComponentDto project : projects) {
            this.copyPermissions(dbSession, template, project, null);
        }
        this.projectIndexers.commitAndIndex(dbSession, projects, ProjectIndexer.Cause.PERMISSION_CHANGE);
    }

    public void applyDefault(DbSession dbSession, String organizationUuid, ComponentDto component, @Nullable Integer projectCreatorUserId) {
        PermissionTemplateDto template = this.findTemplate(dbSession, organizationUuid, component);
        Preconditions.checkArgument((template != null ? 1 : 0) != 0, (Object)"Cannot retrieve default permission template");
        this.copyPermissions(dbSession, template, component, projectCreatorUserId);
    }

    public boolean hasDefaultTemplateWithPermissionOnProjectCreator(DbSession dbSession, String organizationUuid, ComponentDto component) {
        PermissionTemplateDto template = this.findTemplate(dbSession, organizationUuid, component);
        return this.hasProjectCreatorPermission(dbSession, template);
    }

    private boolean hasProjectCreatorPermission(DbSession dbSession, @Nullable PermissionTemplateDto template) {
        return template != null && this.dbClient.permissionTemplateCharacteristicDao().selectByTemplateIds(dbSession, Collections.singletonList(template.getId())).stream().anyMatch(PermissionTemplateCharacteristicDto::getWithProjectCreator);
    }

    private void copyPermissions(DbSession dbSession, PermissionTemplateDto template, ComponentDto project, @Nullable Integer projectCreatorUserId) {
        this.dbClient.groupPermissionDao().deleteByRootComponentId(dbSession, project.getId().longValue());
        this.dbClient.userPermissionDao().deleteProjectPermissions(dbSession, project.getId().longValue());
        List usersPermissions = this.dbClient.permissionTemplateDao().selectUserPermissionsByTemplateId(dbSession, template.getId().longValue());
        String organizationUuid = template.getOrganizationUuid();
        usersPermissions.stream().filter(up -> PermissionTemplateService.permissionValidForProject(project, up.getPermission())).forEach(up -> {
            UserPermissionDto dto = new UserPermissionDto(organizationUuid, up.getPermission(), up.getUserId().intValue(), project.getId());
            this.dbClient.userPermissionDao().insert(dbSession, dto);
        });
        List groupsPermissions = this.dbClient.permissionTemplateDao().selectGroupPermissionsByTemplateId(dbSession, template.getId().longValue());
        groupsPermissions.stream().filter(gp -> PermissionTemplateService.groupNameValidForProject(project, gp.getGroupName())).filter(gp -> PermissionTemplateService.permissionValidForProject(project, gp.getPermission())).forEach(gp -> {
            GroupPermissionDto dto = new GroupPermissionDto().setOrganizationUuid(organizationUuid).setGroupId(DefaultGroups.isAnyone((String)gp.getGroupName()) ? null : gp.getGroupId()).setRole(gp.getPermission()).setResourceId(project.getId());
            this.dbClient.groupPermissionDao().insert(dbSession, dto);
        });
        List characteristics = this.dbClient.permissionTemplateCharacteristicDao().selectByTemplateIds(dbSession, Arrays.asList(template.getId()));
        if (projectCreatorUserId != null) {
            Set permissionsForCurrentUserAlreadyInDb = usersPermissions.stream().filter(userPermission -> projectCreatorUserId.equals(userPermission.getUserId())).map(PermissionTemplateUserDto::getPermission).collect(Collectors.toSet());
            characteristics.stream().filter(PermissionTemplateCharacteristicDto::getWithProjectCreator).filter(up -> PermissionTemplateService.permissionValidForProject(project, up.getPermission())).filter(characteristic -> !permissionsForCurrentUserAlreadyInDb.contains(characteristic.getPermission())).forEach(c -> {
                UserPermissionDto dto = new UserPermissionDto(organizationUuid, c.getPermission(), projectCreatorUserId.intValue(), project.getId());
                this.dbClient.userPermissionDao().insert(dbSession, dto);
            });
        }
    }

    private static boolean permissionValidForProject(ComponentDto project, String permission) {
        return project.isPrivate() || !ProjectPermissions.PUBLIC_PERMISSIONS.contains(permission);
    }

    private static boolean groupNameValidForProject(ComponentDto project, String groupName) {
        return !project.isPrivate() || !DefaultGroups.isAnyone((String)groupName);
    }

    @CheckForNull
    private PermissionTemplateDto findTemplate(DbSession dbSession, String organizationUuid, ComponentDto component) {
        List allPermissionTemplates = this.dbClient.permissionTemplateDao().selectAll(dbSession, organizationUuid, null);
        ArrayList<PermissionTemplateDto> matchingTemplates = new ArrayList<PermissionTemplateDto>();
        for (PermissionTemplateDto permissionTemplateDto : allPermissionTemplates) {
            String keyPattern = permissionTemplateDto.getKeyPattern();
            if (!StringUtils.isNotBlank((String)keyPattern) || !component.getDbKey().matches(keyPattern)) continue;
            matchingTemplates.add(permissionTemplateDto);
        }
        PermissionTemplateService.checkAtMostOneMatchForComponentKey(component.getDbKey(), matchingTemplates);
        if (matchingTemplates.size() == 1) {
            return (PermissionTemplateDto)matchingTemplates.get(0);
        }
        DefaultTemplates defaultTemplates = (DefaultTemplates)this.dbClient.organizationDao().getDefaultTemplates(dbSession, organizationUuid).orElseThrow(() -> new IllegalStateException(String.format("No Default templates defined for organization with uuid '%s'", organizationUuid)));
        String qualifier = component.qualifier();
        DefaultTemplatesResolver.ResolvedDefaultTemplates resolvedDefaultTemplates = this.defaultTemplatesResolver.resolve(defaultTemplates);
        switch (qualifier) {
            case "TRK": {
                return this.dbClient.permissionTemplateDao().selectByUuid(dbSession, resolvedDefaultTemplates.getProject());
            }
            case "VW": 
            case "APP": {
                String viewDefaultTemplateUuid = resolvedDefaultTemplates.getView().orElseThrow(() -> new IllegalStateException("Attempt to create a view when Governance plugin is not installed"));
                return this.dbClient.permissionTemplateDao().selectByUuid(dbSession, viewDefaultTemplateUuid);
            }
        }
        throw new IllegalArgumentException(String.format("Qualifier '%s' is not supported", qualifier));
    }

    private static void checkAtMostOneMatchForComponentKey(String componentKey, List<PermissionTemplateDto> matchingTemplates) {
        if (matchingTemplates.size() > 1) {
            StringBuilder templatesNames = new StringBuilder();
            Iterator<PermissionTemplateDto> it = matchingTemplates.iterator();
            while (it.hasNext()) {
                templatesNames.append("\"").append(it.next().getName()).append("\"");
                if (!it.hasNext()) continue;
                templatesNames.append(", ");
            }
            throw new IllegalStateException(MessageFormat.format("The \"{0}\" key matches multiple permission templates: {1}. A system administrator must update these templates so that only one of them matches the key.", componentKey, templatesNames.toString()));
        }
    }
}

