/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import javax.annotation.CheckForNull;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.organization.OrganizationValidation;
import org.sonarqube.ws.Organizations;

public class OrganizationsWsSupport {
    static final String PARAM_ORGANIZATION = "organization";
    static final String PARAM_KEY = "key";
    static final String PARAM_NAME = "name";
    static final String PARAM_DESCRIPTION = "description";
    static final String PARAM_URL = "url";
    static final String PARAM_AVATAR_URL = "avatar";
    static final String PARAM_LOGIN = "login";
    private final OrganizationValidation organizationValidation;

    public OrganizationsWsSupport(OrganizationValidation organizationValidation) {
        this.organizationValidation = organizationValidation;
    }

    String getAndCheckMandatoryName(Request request) {
        String name = request.mandatoryParam(PARAM_NAME);
        this.organizationValidation.checkName(name);
        return name;
    }

    @CheckForNull
    String getAndCheckName(Request request) {
        String name = request.param(PARAM_NAME);
        if (name != null) {
            this.organizationValidation.checkName(name);
        }
        return name;
    }

    @CheckForNull
    String getAndCheckAvatar(Request request) {
        return this.organizationValidation.checkAvatar(request.param(PARAM_AVATAR_URL));
    }

    @CheckForNull
    String getAndCheckUrl(Request request) {
        return this.organizationValidation.checkUrl(request.param(PARAM_URL));
    }

    @CheckForNull
    String getAndCheckDescription(Request request) {
        return this.organizationValidation.checkDescription(request.param(PARAM_DESCRIPTION));
    }

    void addOrganizationDetailsParams(WebService.NewAction action, boolean isNameRequired) {
        action.createParam(PARAM_NAME).setRequired(isNameRequired).setDescription("Name of the organization. <br />It must be between 2 and 64 chars longs.").setExampleValue((Object)"Foo Company");
        action.createParam(PARAM_DESCRIPTION).setRequired(false).setDescription("Description of the organization.<br/> It must be less than 256 chars long.").setExampleValue((Object)"The Foo company produces quality software for Bar.");
        action.createParam(PARAM_URL).setRequired(false).setDescription("URL of the organization.<br/> It must be less than 256 chars long.").setExampleValue((Object)"https://www.foo.com");
        action.createParam(PARAM_AVATAR_URL).setRequired(false).setDescription("URL of the organization avatar.<br/> It must be less than 256 chars long.").setExampleValue((Object)"https://www.foo.com/foo.png");
    }

    Organizations.Organization toOrganization(OrganizationDto dto) {
        return this.toOrganization(Organizations.Organization.newBuilder(), dto);
    }

    Organizations.Organization toOrganization(Organizations.Organization.Builder builder, OrganizationDto dto) {
        builder.clear().setName(dto.getName()).setKey(dto.getKey()).setGuarded(dto.isGuarded());
        Protobuf.setNullable((Object)dto.getDescription(), arg_0 -> ((Organizations.Organization.Builder)builder).setDescription(arg_0));
        Protobuf.setNullable((Object)dto.getUrl(), arg_0 -> ((Organizations.Organization.Builder)builder).setUrl(arg_0));
        Protobuf.setNullable((Object)dto.getAvatarUrl(), arg_0 -> ((Organizations.Organization.Builder)builder).setAvatar(arg_0));
        return builder.build();
    }
}

