/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import java.util.Objects;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;

@ComputeEngineSide
@ServerSide
public interface BillingValidations {
    public void checkOnProjectAnalysis(Organization var1);

    public void checkCanUpdateProjectVisibility(Organization var1, boolean var2);

    public boolean canUpdateProjectVisibilityToPrivate(Organization var1);

    public static class BillingValidationsException
    extends RuntimeException {
        public BillingValidationsException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    public static class Organization {
        private final String key;
        private final String uuid;

        public Organization(String key, String uuid) {
            this.key = Objects.requireNonNull(key, "Organization key cannot be null");
            this.uuid = Objects.requireNonNull(uuid, "Organization uuid cannot be null");
        }

        public String getKey() {
            return this.key;
        }

        public String getUuid() {
            return this.uuid;
        }
    }
}

