/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification.ws;

import java.util.List;
import java.util.Optional;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.notification.NotificationCenter;
import org.sonar.server.notification.NotificationUpdater;
import org.sonar.server.notification.email.EmailNotificationChannel;
import org.sonar.server.notification.ws.NotificationsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.notification.AddRequest;

public class AddAction
implements NotificationsWsAction {
    private final NotificationCenter notificationCenter;
    private final NotificationUpdater notificationUpdater;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final List<String> globalDispatchers;
    private final List<String> projectDispatchers;

    public AddAction(NotificationCenter notificationCenter, NotificationUpdater notificationUpdater, DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.notificationCenter = notificationCenter;
        this.notificationUpdater = notificationUpdater;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.globalDispatchers = (List)notificationCenter.getDispatcherKeysForProperty("globalNotification", "true").stream().sorted().collect(MoreCollectors.toList());
        this.projectDispatchers = (List)notificationCenter.getDispatcherKeysForProperty("perProjectNotification", "true").stream().sorted().collect(MoreCollectors.toList());
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add").setDescription("Add a notification for the authenticated user.<br>Requires one of the following permissions:<ul> <li>Authentication if no login is provided. If a project is provided, requires the 'Browse' permission on the specified project.</li> <li>System administration if a login is provided. If a project is provided, requires the 'Browse' permission on the specified project.</li></ul>").setSince("6.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("project").setDescription("Project key").setExampleValue((Object)"my_project");
        List<NotificationChannel> channels = this.notificationCenter.getChannels();
        action.createParam("channel").setDescription("Channel through which the notification is sent. For example, notifications can be sent by email.").setPossibleValues(channels).setDefaultValue((Object)EmailNotificationChannel.class.getSimpleName());
        action.createParam("type").setDescription("Notification type. Possible values are for:<ul>  <li>Global notifications: %s</li>  <li>Per project notifications: %s</li></ul>", new Object[]{String.join((CharSequence)", ", this.globalDispatchers), String.join((CharSequence)", ", this.projectDispatchers)}).setRequired(true).setExampleValue((Object)"SQ-MyNewIssues");
        action.createParam("login").setDescription("User login").setSince("6.4");
    }

    public void handle(Request request, Response response) throws Exception {
        AddRequest addRequest = this.toWsRequest(request);
        this.add(addRequest);
        response.noContent();
    }

    private void add(AddRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.checkPermissions(request);
            UserDto user = this.getUser(dbSession, request);
            Optional<ComponentDto> project = this.searchProject(dbSession, request);
            this.notificationUpdater.add(dbSession, request.getChannel(), request.getType(), user, project.orElse(null));
            dbSession.commit();
        }
    }

    private UserDto getUser(DbSession dbSession, AddRequest request) {
        String login = request.getLogin() == null ? this.userSession.getLogin() : request.getLogin();
        return WsUtils.checkFound(this.dbClient.userDao().selectByLogin(dbSession, login), "User '%s' not found", login);
    }

    private Optional<ComponentDto> searchProject(DbSession dbSession, AddRequest request) {
        Optional<ComponentDto> project = request.getProject() == null ? Optional.empty() : Optional.of(this.componentFinder.getByKey(dbSession, request.getProject()));
        project.ifPresent(p -> WsUtils.checkRequest("TRK".equals(p.qualifier()) && "PRJ".equals(p.scope()), "Component '%s' must be a project", request.getProject()));
        project.ifPresent(p -> this.userSession.checkComponentPermission("user", (ComponentDto)p));
        return project;
    }

    private void checkPermissions(AddRequest request) {
        if (request.getLogin() == null) {
            this.userSession.checkLoggedIn();
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }

    private AddRequest toWsRequest(Request request) {
        AddRequest.Builder requestBuilder = AddRequest.builder().setType(request.mandatoryParam("type")).setChannel(request.mandatoryParam("channel"));
        Protobuf.setNullable((Object)request.param("project"), arg_0 -> ((AddRequest.Builder)requestBuilder).setProject(arg_0));
        Protobuf.setNullable((Object)request.param("login"), arg_0 -> ((AddRequest.Builder)requestBuilder).setLogin(arg_0));
        AddRequest wsRequest = requestBuilder.build();
        if (wsRequest.getProject() == null) {
            WsUtils.checkRequest(this.globalDispatchers.contains(wsRequest.getType()), "Value of parameter '%s' (%s) must be one of: %s", "type", wsRequest.getType(), this.globalDispatchers);
        } else {
            WsUtils.checkRequest(this.projectDispatchers.contains(wsRequest.getType()), "Value of parameter '%s' (%s) must be one of: %s", "type", wsRequest.getType(), this.projectDispatchers);
        }
        return wsRequest;
    }
}

