/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.measure.MeasureQuery;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.metric.MetricDtoFunctions;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.measure.ws.ComponentDtoToWsComponent;
import org.sonar.server.measure.ws.MeasuresWsAction;
import org.sonar.server.measure.ws.MeasuresWsParametersBuilder;
import org.sonar.server.measure.ws.MetricDtoToWsMetric;
import org.sonar.server.measure.ws.MetricDtoWithBestValue;
import org.sonar.server.measure.ws.SnapshotDtoToWsPeriods;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsMeasures;
import org.sonarqube.ws.client.measure.ComponentWsRequest;

public class ComponentAction
implements MeasuresWsAction {
    private static final Set<String> QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE = ImmutableSortedSet.of((Comparable)((Object)"FIL"), (Comparable)((Object)"UTS"));
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;

    public ComponentAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("component").setDescription(String.format("Return component with specified measures. The %s or the %s parameter must be provided.<br>Requires the following permission: 'Browse' on the project of specified component.", "componentId", "component")).setResponseExample(this.getClass().getResource("component-example.json")).setSince("5.4").setChangelog(new Change[]{new Change("6.6", "the response field id is deprecated. Use key instead."), new Change("6.6", "the response field refId is deprecated. Use refKey instead.")}).setHandler((RequestHandler)this);
        action.createParam("component").setDescription("Component key").setExampleValue((Object)"my_project").setDeprecatedKey("componentKey", "6.6");
        action.createParam("componentId").setDescription("Component id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setDeprecatedSince("6.6");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        MeasuresWsParametersBuilder.createMetricKeysParameter(action);
        MeasuresWsParametersBuilder.createAdditionalFieldsParameter(action);
        MeasuresWsParametersBuilder.createDeveloperParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        WsMeasures.ComponentWsResponse componentWsResponse = this.doHandle(ComponentAction.toComponentWsRequest(request));
        WsUtils.writeProtobuf((Message)componentWsResponse, request, response);
    }

    private WsMeasures.ComponentWsResponse doHandle(ComponentWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, request);
            Long developerId = this.searchDeveloperId(dbSession, request);
            Optional<ComponentDto> refComponent = this.getReferenceComponent(dbSession, component);
            this.checkPermissions(component);
            SnapshotDto analysis = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, component.projectUuid()).orElse(null);
            List<MetricDto> metrics = this.searchMetrics(dbSession, request);
            List<WsMeasures.Period> periods = SnapshotDtoToWsPeriods.snapshotToWsPeriods(analysis);
            List<MeasureDto> measures = this.searchMeasures(dbSession, component, analysis, metrics, developerId);
            WsMeasures.ComponentWsResponse componentWsResponse = ComponentAction.buildResponse(request, component, refComponent, measures, metrics, periods);
            return componentWsResponse;
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, ComponentWsRequest request) {
        String componentKey = request.getComponent();
        String componentId = request.getComponentId();
        String branch = request.getBranch();
        Preconditions.checkArgument((componentId == null || branch == null ? 1 : 0) != 0, (String)"'%s' and '%s' parameters cannot be used at the same time", (Object[])new Object[]{"componentId", "branch"});
        return branch == null ? this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.COMPONENT_ID_AND_COMPONENT) : this.componentFinder.getByKeyAndBranch(dbSession, componentKey, branch);
    }

    @CheckForNull
    private Long searchDeveloperId(DbSession dbSession, ComponentWsRequest request) {
        if (request.getDeveloperId() == null && request.getDeveloperKey() == null) {
            return null;
        }
        return this.componentFinder.getByUuidOrKey(dbSession, request.getDeveloperId(), request.getDeveloperKey(), ComponentFinder.ParamNames.DEVELOPER_ID_AND_KEY).getId();
    }

    private Optional<ComponentDto> getReferenceComponent(DbSession dbSession, ComponentDto component) {
        if (component.getCopyResourceUuid() == null) {
            return Optional.absent();
        }
        return this.dbClient.componentDao().selectByUuid(dbSession, component.getCopyResourceUuid());
    }

    private static WsMeasures.ComponentWsResponse buildResponse(ComponentWsRequest request, ComponentDto component, Optional<ComponentDto> refComponent, List<MeasureDto> measures, List<MetricDto> metrics, List<WsMeasures.Period> periods) {
        WsMeasures.ComponentWsResponse.Builder response = WsMeasures.ComponentWsResponse.newBuilder();
        ImmutableMap metricsById = Maps.uniqueIndex(metrics, MetricDto::getId);
        HashMap<MetricDto, MeasureDto> measuresByMetric = new HashMap<MetricDto, MeasureDto>();
        for (MeasureDto measure : measures) {
            MetricDto metric = (MetricDto)metricsById.get(measure.getMetricId());
            measuresByMetric.put(metric, measure);
        }
        if (refComponent.isPresent()) {
            response.setComponent(ComponentDtoToWsComponent.componentDtoToWsComponent(component, measuresByMetric, Collections.singletonMap(((ComponentDto)refComponent.get()).uuid(), refComponent.get())));
        } else {
            response.setComponent(ComponentDtoToWsComponent.componentDtoToWsComponent(component, measuresByMetric, Collections.emptyMap()));
        }
        List additionalFields = request.getAdditionalFields();
        if (additionalFields != null) {
            if (additionalFields.contains("metrics")) {
                for (MetricDto metric : metrics) {
                    response.getMetricsBuilder().addMetrics(MetricDtoToWsMetric.metricDtoToWsMetric(metric));
                }
            }
            if (additionalFields.contains("periods")) {
                response.getPeriodsBuilder().addAllPeriods(periods);
            }
        }
        return response.build();
    }

    private List<MetricDto> searchMetrics(DbSession dbSession, ComponentWsRequest request) {
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, request.getMetricKeys());
        if (metrics.size() < request.getMetricKeys().size()) {
            List foundMetricKeys = Lists.transform((List)metrics, MetricDto::getKey);
            Sets.SetView missingMetricKeys = Sets.difference(new LinkedHashSet(request.getMetricKeys()), new LinkedHashSet(foundMetricKeys));
            throw new NotFoundException(String.format("The following metric keys are not found: %s", Joiner.on((String)", ").join((Iterable)missingMetricKeys)));
        }
        return metrics;
    }

    private List<MeasureDto> searchMeasures(DbSession dbSession, ComponentDto component, @Nullable SnapshotDto analysis, List<MetricDto> metrics, @Nullable Long developerId) {
        if (analysis == null) {
            return Collections.emptyList();
        }
        List metricIds = Lists.transform(metrics, MetricDto::getId);
        MeasureQuery query = MeasureQuery.builder().setPersonId(developerId).setMetricIds((Collection)metricIds).setComponentUuid(component.uuid()).build();
        List measures = this.dbClient.measureDao().selectByQuery(dbSession, query);
        ComponentAction.addBestValuesToMeasures(measures, component, metrics);
        return measures;
    }

    private static void addBestValuesToMeasures(List<MeasureDto> measures, ComponentDto component, List<MetricDto> metrics) {
        if (!QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE.contains(component.qualifier())) {
            return;
        }
        List metricWithBestValueList = (List)metrics.stream().filter(MetricDtoFunctions.isOptimizedForBestValue()).map(new MetricDtoWithBestValue.MetricDtoToMetricDtoWithBestValueFunction()).collect(MoreCollectors.toList((int)metrics.size()));
        ImmutableMap measuresByMetricId = Maps.uniqueIndex(measures, MeasureDto::getMetricId);
        for (MetricDtoWithBestValue metricWithBestValue : metricWithBestValueList) {
            if (measuresByMetricId.get(metricWithBestValue.getMetric().getId()) != null) continue;
            measures.add(metricWithBestValue.getBestValue());
        }
    }

    private static ComponentWsRequest toComponentWsRequest(Request request) {
        ComponentWsRequest componentWsRequest = new ComponentWsRequest().setComponentId(request.param("componentId")).setComponent(request.param("component")).setBranch(request.param("branch")).setAdditionalFields(request.paramAsStrings("additionalFields")).setMetricKeys(request.mandatoryParamAsStrings("metricKeys")).setDeveloperId(request.param("developerId")).setDeveloperKey(request.param("developerKey"));
        WsUtils.checkRequest(!componentWsRequest.getMetricKeys().isEmpty(), "At least one metric key must be provided", new Object[0]);
        return componentWsRequest;
    }

    private void checkPermissions(ComponentDto baseComponent) {
        this.userSession.checkComponentPermission("user", baseComponent);
    }
}

