/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.OperationResponseWriter;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;

public class DeleteCommentAction
implements IssuesWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueFinder issueFinder;
    private final OperationResponseWriter responseWriter;

    public DeleteCommentAction(UserSession userSession, DbClient dbClient, IssueFinder issueFinder, OperationResponseWriter responseWriter) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueFinder = issueFinder;
        this.responseWriter = responseWriter;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete_comment").setDescription("Delete a comment.<br/>Requires authentication and the following permission: 'Browse' on the project of the specified issue.").setSince("3.6").setChangelog(new Change[]{new Change("6.5", "the response field components.uuid is deprecated. Use components.key instead."), new Change("6.5", "the database ids of the components are removed from the response"), new Change("6.3", "the response returns the issue with all its details"), new Change("6.3", "the 'key' parameter is renamed 'comment'")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"delete_comment-example.json")).setPost(true);
        action.createParam("comment").setDescription("Comment key").setDeprecatedKey("key", "6.3").setSince("6.3").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
    }

    public void handle(Request request, Response response) {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            IssueDto issueDto = ((CommentData)Stream.of(request).map(this.loadCommentData(dbSession)).peek(this.deleteComment(dbSession)).collect(MoreCollectors.toOneElement())).getIssueDto();
            this.responseWriter.write(issueDto.getKey(), new SearchResponseData(issueDto), request, response);
        }
    }

    private Function<Request, CommentData> loadCommentData(DbSession dbSession) {
        return request -> new CommentData(dbSession, request.mandatoryParam("comment"));
    }

    private Consumer<CommentData> deleteComment(DbSession dbSession) {
        return commentData -> {
            this.dbClient.issueChangeDao().delete(dbSession, commentData.getIssueChangeDto().getKey());
            dbSession.commit();
        };
    }

    private class CommentData {
        private final IssueChangeDto issueChangeDto;
        private final IssueDto issueDto;

        CommentData(DbSession dbSession, String commentKey) {
            this.issueChangeDto = (IssueChangeDto)DeleteCommentAction.this.dbClient.issueChangeDao().selectCommentByKey(dbSession, commentKey).orElseThrow(() -> new NotFoundException(String.format("Comment with key '%s' does not exist", commentKey)));
            this.issueDto = DeleteCommentAction.this.issueFinder.getByKey(dbSession, this.issueChangeDto.getIssueKey());
            Preconditions.checkArgument((boolean)Objects.equals(this.issueChangeDto.getUserLogin(), DeleteCommentAction.this.userSession.getLogin()), (Object)"You can only delete your own comments");
        }

        IssueChangeDto getIssueChangeDto() {
            return this.issueChangeDto;
        }

        IssueDto getIssueDto() {
            return this.issueDto;
        }
    }
}

