/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Duration;
import org.sonar.server.es.BaseDoc;

public class IssueDoc
extends BaseDoc {
    public IssueDoc(Map<String, Object> fields) {
        super(fields);
    }

    public IssueDoc() {
        super(Maps.newHashMapWithExpectedSize((int)32));
    }

    @Override
    public String getId() {
        return this.key();
    }

    @Override
    public String getRouting() {
        return this.projectUuid();
    }

    @Override
    public String getParent() {
        return this.projectUuid();
    }

    public String key() {
        return (String)this.getField("key");
    }

    public String componentUuid() {
        return (String)this.getField("component");
    }

    @CheckForNull
    public String moduleUuid() {
        return (String)this.getField("module");
    }

    public String modulePath() {
        return (String)this.getField("modulePath");
    }

    public String projectUuid() {
        return (String)this.getField("project");
    }

    public String branchUuid() {
        return (String)this.getField("branch");
    }

    public boolean isMainBranch() {
        return (Boolean)this.getField("isMainBranch");
    }

    public RuleKey ruleKey() {
        return RuleKey.parse((String)((String)this.getField("ruleKey")));
    }

    public String language() {
        return (String)this.getField("language");
    }

    public String severity() {
        return (String)this.getField("severity");
    }

    @CheckForNull
    public Integer line() {
        return (Integer)this.getNullableField("line");
    }

    public String status() {
        return (String)this.getField("status");
    }

    @CheckForNull
    public String resolution() {
        return (String)this.getNullableField("resolution");
    }

    @CheckForNull
    public String assignee() {
        return (String)this.getNullableField("assignee");
    }

    public Date creationDate() {
        return this.getFieldAsDate("issueCreatedAt");
    }

    public Date updateDate() {
        return this.getFieldAsDate("issueUpdatedAt");
    }

    @CheckForNull
    public Date closeDate() {
        return this.getNullableFieldAsDate("issueClosedAt");
    }

    @CheckForNull
    public String authorLogin() {
        return (String)this.getNullableField("authorLogin");
    }

    public RuleType type() {
        return RuleType.valueOf((String)((String)this.getField("type")));
    }

    @CheckForNull
    public Duration effort() {
        Number effort = (Number)this.getNullableField("effort");
        return effort != null ? Duration.create((long)effort.longValue()) : null;
    }

    @CheckForNull
    public String filePath() {
        return (String)this.getNullableField("filePath");
    }

    @CheckForNull
    public String directoryPath() {
        return (String)this.getNullableField("dirPath");
    }

    @CheckForNull
    public String organizationUuid() {
        return (String)this.getNullableField("organization");
    }

    public IssueDoc setKey(@Nullable String s) {
        this.setField("key", s);
        return this;
    }

    public IssueDoc setComponentUuid(@Nullable String s) {
        this.setField("component", s);
        return this;
    }

    public IssueDoc setModuleUuid(@Nullable String s) {
        this.setField("module", s);
        return this;
    }

    public IssueDoc setProjectUuid(String s) {
        this.setField("project", s);
        return this;
    }

    public IssueDoc setBranchUuid(String s) {
        this.setField("branch", s);
        return this;
    }

    public IssueDoc setIsMainBranch(boolean b) {
        this.setField("isMainBranch", b);
        return this;
    }

    public IssueDoc setRuleKey(@Nullable String s) {
        this.setField("ruleKey", s);
        return this;
    }

    public IssueDoc setLanguage(@Nullable String s) {
        this.setField("language", s);
        return this;
    }

    public IssueDoc setSeverity(@Nullable String s) {
        this.setField("severity", s);
        this.setField("severityValue", Severity.ALL.indexOf(s));
        return this;
    }

    public IssueDoc setLine(@Nullable Integer i) {
        this.setField("line", i);
        return this;
    }

    public IssueDoc setStatus(@Nullable String s) {
        this.setField("status", s);
        return this;
    }

    public IssueDoc setResolution(@Nullable String s) {
        this.setField("resolution", s);
        return this;
    }

    public IssueDoc setAssignee(@Nullable String s) {
        this.setField("assignee", s);
        return this;
    }

    public IssueDoc setFuncUpdateDate(@Nullable Date d) {
        this.setField("issueUpdatedAt", d);
        return this;
    }

    public IssueDoc setFuncCreationDate(@Nullable Date d) {
        this.setField("issueCreatedAt", d);
        return this;
    }

    public IssueDoc setFuncCloseDate(@Nullable Date d) {
        this.setField("issueClosedAt", d);
        return this;
    }

    public IssueDoc setAuthorLogin(@Nullable String s) {
        this.setField("authorLogin", s);
        return this;
    }

    public IssueDoc setEffort(@Nullable Long l) {
        this.setField("effort", l);
        return this;
    }

    public IssueDoc setFilePath(@Nullable String s) {
        this.setField("filePath", s);
        return this;
    }

    public IssueDoc setDirectoryPath(@Nullable String s) {
        this.setField("dirPath", s);
        return this;
    }

    public IssueDoc setModuleUuidPath(@Nullable String s) {
        this.setField("modulePath", s);
        return this;
    }

    @CheckForNull
    public Collection<String> getTags() {
        return (Collection)this.getNullableField("tags");
    }

    public IssueDoc setTags(@Nullable Collection<String> tags) {
        this.setField("tags", tags);
        return this;
    }

    public IssueDoc setType(RuleType type) {
        this.setField("type", type.toString());
        return this;
    }

    public IssueDoc setOrganizationUuid(String s) {
        this.setField("organization", s);
        return this;
    }
}

