/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class Result<T> {
    private T object = null;
    private final List<Message> errors = Lists.newArrayList();

    private Result(@Nullable T object) {
        this.object = object;
    }

    public static <T> Result<T> of() {
        return new Result<Object>(null);
    }

    public Result<T> set(@Nullable T object) {
        this.object = object;
        return this;
    }

    public T get() {
        return this.object;
    }

    public Result<T> addError(String text) {
        return this.addError(Message.of(text));
    }

    public Result<T> addError(Message message) {
        this.errors.add(message);
        return this;
    }

    public List<Message> errors() {
        return this.errors;
    }

    public boolean ok() {
        return this.errors.isEmpty();
    }

    public int httpStatus() {
        if (this.ok()) {
            return 200;
        }
        return 400;
    }

    public static class Message {
        private final String l10nKey;
        private final Object[] l10nParams;
        private final String text;

        private Message(@Nullable String l10nKey, @Nullable Object[] l10nParams, @Nullable String text) {
            this.l10nKey = l10nKey;
            this.l10nParams = l10nParams;
            this.text = text;
        }

        public static Message of(String text) {
            return new Message(null, null, text);
        }

        public static Message ofL10n(String l10nKey, Object ... l10nParams) {
            return new Message(l10nKey, l10nParams, null);
        }

        @CheckForNull
        public String text() {
            return this.text;
        }

        @CheckForNull
        public String l10nKey() {
            return this.l10nKey;
        }

        @CheckForNull
        public Object[] l10nParams() {
            return this.l10nParams;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message = (Message)o;
            if (this.l10nKey != null ? !this.l10nKey.equals(message.l10nKey) : message.l10nKey != null) {
                return false;
            }
            return Arrays.equals(this.l10nParams, message.l10nParams) && (this.text != null ? this.text.equals(message.text) : message.text == null);
        }

        public int hashCode() {
            int result = this.l10nKey != null ? this.l10nKey.hashCode() : 0;
            result = 31 * result + (this.l10nParams != null ? Arrays.hashCode(this.l10nParams) : 0);
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this).toString();
        }
    }
}

