/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.issue.Action;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.user.UserSession;

@ServerSide
public class CommentAction
extends Action {
    public static final String COMMENT_KEY = "comment";
    public static final String COMMENT_PROPERTY = "comment";
    private final IssueFieldsSetter issueUpdater;

    public CommentAction(IssueFieldsSetter issueUpdater) {
        super("comment");
        this.issueUpdater = issueUpdater;
    }

    @Override
    public boolean verify(Map<String, Object> properties, Collection<DefaultIssue> issues, UserSession userSession) {
        CommentAction.comment(properties);
        return true;
    }

    @Override
    public boolean execute(Map<String, Object> properties, Action.Context context) {
        this.issueUpdater.addComment(context.issue(), CommentAction.comment(properties), context.issueChangeContext());
        return true;
    }

    private static String comment(Map<String, Object> properties) {
        String param = (String)properties.get("comment");
        if (Strings.isNullOrEmpty((String)param)) {
            throw new IllegalArgumentException("Missing parameter : 'comment'");
        }
        return param;
    }
}

