/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import java.util.Arrays;
import java.util.Set;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.process.cluster.health.NodeDetails;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.server.health.ClusterHealthCheck;
import org.sonar.server.health.ClusterHealthSubCheck;
import org.sonar.server.health.Health;
import org.sonar.server.health.HealthReducer;

public class SearchNodeClusterCheck
implements ClusterHealthCheck {
    @Override
    public Health check(Set<NodeHealth> nodeHealths) {
        Set searchNOdes = (Set)nodeHealths.stream().filter(s -> s.getDetails().getType() == NodeDetails.Type.SEARCH).collect(MoreCollectors.toSet());
        return Arrays.stream(SearchNodeClusterSubChecks.values()).map(s -> s.check(searchNOdes)).reduce(Health.GREEN, HealthReducer.INSTANCE);
    }

    private static enum SearchNodeClusterSubChecks implements ClusterHealthSubCheck
    {
        NO_SEARCH_NODE{

            @Override
            public Health check(Set<NodeHealth> searchNodes) {
                int searchNodeCount = searchNodes.size();
                if (searchNodeCount == 0) {
                    return Health.newHealthCheckBuilder().setStatus(Health.Status.RED).addCause("No search node").build();
                }
                return Health.GREEN;
            }
        }
        ,
        NUMBER_OF_NODES{

            @Override
            public Health check(Set<NodeHealth> searchNodes) {
                int searchNodeCount = searchNodes.size();
                if (searchNodeCount == 0) {
                    return Health.GREEN;
                }
                if (searchNodeCount < 3) {
                    long yellowGreenNodesCount = this.withStatus(searchNodes, NodeHealth.Status.GREEN, NodeHealth.Status.YELLOW).count();
                    return Health.newHealthCheckBuilder().setStatus(yellowGreenNodesCount > 1L ? Health.Status.YELLOW : Health.Status.RED).addCause("There should be at least three search nodes").build();
                }
                if (searchNodeCount > 3 && this.isEven(searchNodeCount)) {
                    return Health.newHealthCheckBuilder().setStatus(Health.Status.YELLOW).addCause("There should be an odd number of search nodes").build();
                }
                return Health.GREEN;
            }

            private boolean isEven(int searchNodeCount) {
                return searchNodeCount % 2 == 0;
            }
        }
        ,
        RED_OR_YELLOW_NODES{

            @Override
            public Health check(Set<NodeHealth> searchNodes) {
                long greenNodesCount;
                int searchNodeCount = searchNodes.size();
                if (searchNodeCount == 0) {
                    return Health.GREEN;
                }
                long redNodesCount = this.withStatus(searchNodes, NodeHealth.Status.RED).count();
                long yellowNodesCount = this.withStatus(searchNodes, NodeHealth.Status.YELLOW).count();
                if (redNodesCount == 0L && yellowNodesCount == 0L) {
                    return Health.GREEN;
                }
                Health.Builder builder = Health.newHealthCheckBuilder();
                if (redNodesCount == (long)searchNodeCount) {
                    return builder.setStatus(Health.Status.RED).addCause("Status of all search nodes is RED").build();
                }
                if (redNodesCount > 0L) {
                    builder.addCause("At least one search node is RED");
                }
                if (yellowNodesCount == (long)searchNodeCount) {
                    return builder.setStatus(Health.Status.YELLOW).addCause("Status of all search nodes is YELLOW").build();
                }
                if (yellowNodesCount > 0L) {
                    builder.addCause("At least one search node is YELLOW");
                }
                builder.setStatus((greenNodesCount = this.withStatus(searchNodes, NodeHealth.Status.GREEN).count()) + yellowNodesCount > 1L ? Health.Status.YELLOW : Health.Status.RED);
                return builder.build();
            }
        };

    }
}

