/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.process.cluster.health.SharedHealthState;
import org.sonar.server.health.ClusterHealth;
import org.sonar.server.health.ClusterHealthCheck;
import org.sonar.server.health.Health;
import org.sonar.server.health.HealthChecker;
import org.sonar.server.health.HealthReducer;
import org.sonar.server.health.NodeHealthCheck;
import org.sonar.server.platform.WebServer;

public class HealthCheckerImpl
implements HealthChecker {
    private final WebServer webServer;
    private final List<NodeHealthCheck> nodeHealthChecks;
    private final List<ClusterHealthCheck> clusterHealthChecks;
    @CheckForNull
    private final SharedHealthState sharedHealthState;

    public HealthCheckerImpl(WebServer webServer, NodeHealthCheck[] nodeHealthChecks) {
        this(webServer, nodeHealthChecks, new ClusterHealthCheck[0], null);
    }

    public HealthCheckerImpl(WebServer webServer, NodeHealthCheck[] nodeHealthChecks, ClusterHealthCheck[] clusterHealthChecks, @Nullable SharedHealthState sharedHealthState) {
        this.webServer = webServer;
        this.nodeHealthChecks = ImmutableList.copyOf((Object[])nodeHealthChecks);
        this.clusterHealthChecks = ImmutableList.copyOf((Object[])clusterHealthChecks);
        this.sharedHealthState = sharedHealthState;
    }

    @Override
    public Health checkNode() {
        return this.nodeHealthChecks.stream().map(NodeHealthCheck::check).reduce(Health.GREEN, HealthReducer.INSTANCE);
    }

    @Override
    public ClusterHealth checkCluster() {
        Preconditions.checkState((!this.webServer.isStandalone() ? 1 : 0) != 0, (Object)"Clustering is not enabled");
        Preconditions.checkState((this.sharedHealthState != null ? 1 : 0) != 0, (Object)"HealthState instance can't be null when clustering is enabled");
        Set nodeHealths = this.sharedHealthState.readAll();
        Health health = this.clusterHealthChecks.stream().map(clusterHealthCheck -> clusterHealthCheck.check(nodeHealths)).reduce(Health.GREEN, HealthReducer.INSTANCE);
        return new ClusterHealth(health, nodeHealths);
    }
}

