/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollAction;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxySearchScrollRequestBuilder
extends SearchScrollRequestBuilder {
    public ProxySearchScrollRequestBuilder(String scrollId, Client client) {
        super((ElasticsearchClient)client, SearchScrollAction.INSTANCE, scrollId);
    }

    public SearchResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            SearchResponse searchResponse = (SearchResponse)super.execute().actionGet();
            return searchResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public SearchResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public SearchResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<SearchResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        return String.format("ES search scroll request for scroll id '%s'", ((SearchScrollRequest)super.request()).scroll());
    }
}

