/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.server.es.DocId;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;

public class OneToOneResilientIndexingListener
implements IndexingListener {
    private final DbClient dbClient;
    private final DbSession dbSession;
    private final Multimap<DocId, EsQueueDto> itemsById;

    public OneToOneResilientIndexingListener(DbClient dbClient, DbSession dbSession, Collection<EsQueueDto> items) {
        this.dbClient = dbClient;
        this.dbSession = dbSession;
        this.itemsById = (Multimap)items.stream().collect(MoreCollectors.index(i -> new DocId(IndexType.parse(i.getDocType()), i.getDocId()), Function.identity()));
    }

    @Override
    public void onSuccess(List<DocId> successDocIds) {
        if (!successDocIds.isEmpty()) {
            Collection itemsToDelete = (Collection)successDocIds.stream().map(arg_0 -> this.itemsById.get(arg_0)).flatMap(Collection::stream).filter(Objects::nonNull).collect(MoreCollectors.toArrayList());
            this.dbClient.esQueueDao().delete(this.dbSession, itemsToDelete);
            this.dbSession.commit();
        }
    }

    @Override
    public void onFinish(IndexingResult result) {
    }
}

