/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.NewIndex;

@ServerSide
public class IndexDefinitions
implements Startable {
    private final Map<String, Index> byKey = Maps.newHashMap();
    private final IndexDefinition[] defs;
    private final Configuration config;

    public IndexDefinitions(IndexDefinition[] defs, Configuration config) {
        this.defs = defs;
        this.config = config;
    }

    public Map<String, Index> getIndices() {
        return this.byKey;
    }

    public void start() {
        IndexDefinition.IndexDefinitionContext context = new IndexDefinition.IndexDefinitionContext();
        if (!this.config.getBoolean("sonar.internal.es.disableIndexes").orElse(false).booleanValue()) {
            for (IndexDefinition definition : this.defs) {
                definition.define(context);
            }
            for (Map.Entry entry : context.getIndices().entrySet()) {
                this.byKey.put((String)entry.getKey(), new Index((NewIndex)entry.getValue()));
            }
        }
    }

    public void stop() {
    }

    public static class IndexType {
        private final String name;
        private final Map<String, Object> attributes;

        private IndexType(NewIndex.NewIndexType newType) {
            this.name = newType.getName();
            this.attributes = ImmutableMap.copyOf(newType.getAttributes());
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }

    public static class Index {
        private final String name;
        private final Settings settings;
        private final Map<String, IndexType> types;

        Index(NewIndex newIndex) {
            this.name = newIndex.getName();
            this.settings = newIndex.getSettings().build();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (NewIndex.NewIndexType newIndexType : newIndex.getTypes().values()) {
                IndexType type = new IndexType(newIndexType);
                builder.put((Object)type.getName(), (Object)type);
            }
            this.types = builder.build();
        }

        public String getName() {
            return this.name;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public Map<String, IndexType> getTypes() {
            return this.types;
        }
    }
}

