/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.HasAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.sonar.api.utils.DateUtils;

public class Facets {
    public static final String TOTAL = "total";
    private static final String NO_DATA_PREFIX = "no_data_";
    private final LinkedHashMap<String, LinkedHashMap<String, Long>> facetsByName;
    private final TimeZone timeZone;

    public Facets(LinkedHashMap<String, LinkedHashMap<String, Long>> facetsByName, TimeZone timeZone) {
        this.facetsByName = facetsByName;
        this.timeZone = timeZone;
    }

    public Facets(SearchResponse response, TimeZone timeZone) {
        this.facetsByName = new LinkedHashMap();
        this.timeZone = timeZone;
        Aggregations aggregations = response.getAggregations();
        if (aggregations != null) {
            for (Aggregation facet : aggregations) {
                this.processAggregation(facet);
            }
        }
    }

    private void processAggregation(Aggregation aggregation) {
        if (Missing.class.isAssignableFrom(aggregation.getClass())) {
            this.processMissingAggregation((Missing)aggregation);
        } else if (Terms.class.isAssignableFrom(aggregation.getClass())) {
            this.processTermsAggregation((Terms)aggregation);
        } else if (Filter.class.isAssignableFrom(aggregation.getClass())) {
            this.processSubAggregations((HasAggregations)((Filter)aggregation));
        } else if (HasAggregations.class.isAssignableFrom(aggregation.getClass())) {
            this.processSubAggregations((HasAggregations)aggregation);
        } else if (Histogram.class.isAssignableFrom(aggregation.getClass())) {
            this.processDateHistogram((Histogram)aggregation);
        } else if (Sum.class.isAssignableFrom(aggregation.getClass())) {
            this.processSum((Sum)aggregation);
        } else if (MultiBucketsAggregation.class.isAssignableFrom(aggregation.getClass())) {
            this.processMultiBucketAggregation((MultiBucketsAggregation)aggregation);
        } else {
            throw new IllegalArgumentException("Aggregation type not supported yet: " + aggregation.getClass());
        }
    }

    private void processMissingAggregation(Missing aggregation) {
        long docCount = aggregation.getDocCount();
        if (docCount > 0L) {
            LinkedHashMap<String, Long> facet = this.getOrCreateFacet(aggregation.getName().replace("_missing", ""));
            if (aggregation.getAggregations().getAsMap().containsKey("effort")) {
                facet.put("", Math.round(((Sum)aggregation.getAggregations().get("effort")).getValue()));
            } else {
                facet.put("", docCount);
            }
        }
    }

    private void processTermsAggregation(Terms aggregation) {
        String facetName = aggregation.getName();
        if (facetName.contains("__") && !facetName.startsWith("__")) {
            facetName = facetName.substring(0, facetName.indexOf("__"));
        }
        facetName = facetName.replace("_selected", "");
        LinkedHashMap<String, Long> facet = this.getOrCreateFacet(facetName);
        for (Terms.Bucket value : aggregation.getBuckets()) {
            List aggregationList = value.getAggregations().asList();
            if (aggregationList.size() == 1) {
                facet.put(value.getKeyAsString(), Math.round(((Sum)aggregationList.get(0)).getValue()));
                continue;
            }
            facet.put(value.getKeyAsString(), value.getDocCount());
        }
    }

    private void processSubAggregations(HasAggregations aggregation) {
        Filter filter;
        if (Filter.class.isAssignableFrom(aggregation.getClass()) && (filter = (Filter)aggregation).getName().startsWith(NO_DATA_PREFIX)) {
            LinkedHashMap<String, Long> facet = this.getOrCreateFacet(filter.getName().replaceFirst(NO_DATA_PREFIX, ""));
            facet.put("NO_DATA", ((Filter)aggregation).getDocCount());
        }
        for (Aggregation sub : aggregation.getAggregations()) {
            this.processAggregation(sub);
        }
    }

    private void processDateHistogram(Histogram aggregation) {
        LinkedHashMap<String, Long> facet = this.getOrCreateFacet(aggregation.getName());
        for (Histogram.Bucket value : aggregation.getBuckets()) {
            String day = Facets.dateTimeToDate(value.getKeyAsString(), this.timeZone);
            if (value.getAggregations().getAsMap().containsKey("effort")) {
                facet.put(day, Math.round(((Sum)value.getAggregations().get("effort")).getValue()));
                continue;
            }
            facet.put(day, value.getDocCount());
        }
    }

    private static String dateTimeToDate(String timestamp, TimeZone timeZone) {
        Date date = DateUtils.parseDateTime((String)timestamp);
        return date.toInstant().atZone(timeZone.toZoneId()).toLocalDate().toString();
    }

    private void processSum(Sum aggregation) {
        this.getOrCreateFacet(aggregation.getName()).put(TOTAL, Math.round(aggregation.getValue()));
    }

    private void processMultiBucketAggregation(MultiBucketsAggregation aggregation) {
        LinkedHashMap<String, Long> facet = this.getOrCreateFacet(aggregation.getName());
        aggregation.getBuckets().forEach(bucket -> facet.put(bucket.getKeyAsString(), bucket.getDocCount()));
    }

    public boolean contains(String facetName) {
        return this.facetsByName.containsKey(facetName);
    }

    @CheckForNull
    public LinkedHashMap<String, Long> get(String facetName) {
        return this.facetsByName.get(facetName);
    }

    public Map<String, LinkedHashMap<String, Long>> getAll() {
        return this.facetsByName;
    }

    public Set<String> getBucketKeys(String facetName) {
        LinkedHashMap<String, Long> facet = this.facetsByName.get(facetName);
        if (facet != null) {
            return facet.keySet();
        }
        return Collections.emptySet();
    }

    public Set<String> getNames() {
        return this.facetsByName.keySet();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
    }

    private LinkedHashMap<String, Long> getOrCreateFacet(String facetName) {
        return this.facetsByName.computeIfAbsent(facetName, n -> new LinkedHashMap());
    }
}

