/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.email.ws;

import com.google.common.base.Throwables;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.mail.EmailException;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.email.ws.EmailsWsAction;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.notification.email.EmailNotificationChannel;
import org.sonar.server.user.UserSession;

public class SendAction
implements EmailsWsAction {
    private static final String PARAM_TO = "to";
    private static final String PARAM_SUBJECT = "subject";
    private static final String PARAM_MESSAGE = "message";
    private final UserSession userSession;
    private final EmailNotificationChannel emailNotificationChannel;

    public SendAction(UserSession userSession, EmailNotificationChannel emailNotificationChannel) {
        this.userSession = userSession;
        this.emailNotificationChannel = emailNotificationChannel;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("send").setDescription("Test email configuration by sending an email<br>Requires 'Administer System' permission.").setSince("6.1").setInternal(true).setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_TO).setDescription("Email address").setExampleValue((Object)"john@doo.com").setRequired(true);
        action.createParam(PARAM_SUBJECT).setDescription("Subject of the email").setExampleValue((Object)"Test Message from SonarQube");
        action.createParam(PARAM_MESSAGE).setDescription("Content of the email").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        try {
            this.emailNotificationChannel.sendTestEmail(request.mandatoryParam(PARAM_TO), request.param(PARAM_SUBJECT), request.mandatoryParam(PARAM_MESSAGE));
        }
        catch (EmailException emailException) {
            throw SendAction.createBadRequestException(emailException);
        }
        response.noContent();
    }

    private static BadRequestException createBadRequestException(EmailException emailException) {
        List<String> messages = Throwables.getCausalChain((Throwable)emailException).stream().map(Throwable::getMessage).collect(Collectors.toList());
        Collections.reverse(messages);
        return BadRequestException.create(messages);
    }
}

