/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.qualityprofile.QPMeasureData;
import org.sonar.server.qualityprofile.QualityProfile;

public class UpdateQualityProfilesLastUsedDateStep
implements ComputationStep {
    private final DbClient dbClient;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public UpdateQualityProfilesLastUsedDateStep(DbClient dbClient, AnalysisMetadataHolder analysisMetadataHolder, TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.dbClient = dbClient;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            Component root = this.treeRootHolder.getRoot();
            Metric metric = this.metricRepository.getByKey("quality_profiles");
            Set<QualityProfile> qualityProfiles = UpdateQualityProfilesLastUsedDateStep.parseQualityProfiles(this.measureRepository.getRawMeasure(root, metric));
            if (qualityProfiles.isEmpty()) {
                return;
            }
            List dtos = this.dbClient.qualityProfileDao().selectByUuids(dbSession, qualityProfiles.stream().map(QualityProfile::getQpKey).collect(Collectors.toList()));
            dtos.addAll(this.getAncestors(dbSession, dtos));
            long analysisDate = this.analysisMetadataHolder.getAnalysisDate();
            dtos.forEach(dto -> {
                dto.setLastUsed(Long.valueOf(analysisDate));
                this.dbClient.qualityProfileDao().update(dbSession, dto, new QProfileDto[0]);
            });
            dbSession.commit();
        }
    }

    private List<QProfileDto> getAncestors(DbSession dbSession, List<QProfileDto> dtos) {
        ArrayList<QProfileDto> ancestors = new ArrayList<QProfileDto>();
        dtos.forEach(dto -> this.incrementAncestors(dbSession, (QProfileDto)dto, (List<QProfileDto>)ancestors));
        return ancestors;
    }

    private void incrementAncestors(DbSession session, QProfileDto profile, List<QProfileDto> ancestors) {
        String parentKey = profile.getParentKee();
        if (parentKey != null) {
            QProfileDto parentDto = this.dbClient.qualityProfileDao().selectOrFailByUuid(session, parentKey);
            ancestors.add(parentDto);
            this.incrementAncestors(session, parentDto, ancestors);
        }
    }

    @Override
    public String getDescription() {
        return "Update last usage date of quality profiles";
    }

    private static Set<QualityProfile> parseQualityProfiles(Optional<Measure> measure) {
        if (!measure.isPresent()) {
            return Collections.emptySet();
        }
        String data = ((Measure)measure.get()).getStringValue();
        return data == null ? Collections.emptySet() : QPMeasureData.fromJson(data).getProfiles();
    }
}

