/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.sonar.ce.queue.CeTaskResult;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.computation.taskprocessor.MutableTaskResultHolder;

public class PublishTaskResultStep
implements ComputationStep {
    private final MutableTaskResultHolder taskResultHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public PublishTaskResultStep(MutableTaskResultHolder taskResultHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.taskResultHolder = taskResultHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public String getDescription() {
        return "Publish task results";
    }

    @Override
    public void execute() {
        this.taskResultHolder.setResult(new CeTaskResultImpl(this.analysisMetadataHolder.getUuid()));
    }

    @Immutable
    private static class CeTaskResultImpl
    implements CeTaskResult {
        private final String analysisUuid;

        public CeTaskResultImpl(String analysisUuid) {
            this.analysisUuid = analysisUuid;
        }

        @Override
        public Optional<String> getAnalysisUuid() {
            return Optional.of(this.analysisUuid);
        }
    }
}

