/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.sonar.api.i18n.I18n;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentLinkDto;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistProjectLinksStep
implements ComputationStep {
    private final DbClient dbClient;
    private final I18n i18n;
    private final TreeRootHolder treeRootHolder;
    private final BatchReportReader reportReader;
    private static final Map<ScannerReport.ComponentLink.ComponentLinkType, String> typesConverter = ImmutableMap.of((Object)ScannerReport.ComponentLink.ComponentLinkType.HOME, (Object)"homepage", (Object)ScannerReport.ComponentLink.ComponentLinkType.SCM, (Object)"scm", (Object)ScannerReport.ComponentLink.ComponentLinkType.SCM_DEV, (Object)"scm_dev", (Object)ScannerReport.ComponentLink.ComponentLinkType.CI, (Object)"ci", (Object)ScannerReport.ComponentLink.ComponentLinkType.ISSUE, (Object)"issue");

    public PersistProjectLinksStep(DbClient dbClient, I18n i18n, TreeRootHolder treeRootHolder, BatchReportReader reportReader) {
        this.dbClient = dbClient;
        this.i18n = i18n;
        this.treeRootHolder = treeRootHolder;
        this.reportReader = reportReader;
    }

    @Override
    public void execute() {
        try (DbSession session = this.dbClient.openSession(false);){
            new DepthTraversalTypeAwareCrawler(new ProjectLinkVisitor(session)).visit(this.treeRootHolder.getRoot());
            session.commit();
        }
    }

    @Override
    public String getDescription() {
        return "Persist project links";
    }

    private class ProjectLinkVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;

        private ProjectLinkVisitor(DbSession session) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
            this.session = session;
        }

        @Override
        public void visitProject(Component project) {
            this.processComponent(project);
        }

        @Override
        public void visitModule(Component module) {
            this.processComponent(module);
        }

        private void processComponent(Component component) {
            ScannerReport.Component batchComponent = PersistProjectLinksStep.this.reportReader.readComponent(component.getReportAttributes().getRef());
            this.processLinks(component.getUuid(), batchComponent.getLinkList());
        }

        private void processLinks(String componentUuid, List<ScannerReport.ComponentLink> links) {
            List previousLinks = PersistProjectLinksStep.this.dbClient.componentLinkDao().selectByComponentUuid(this.session, componentUuid);
            this.mergeLinks(this.session, componentUuid, links, previousLinks);
        }

        private void mergeLinks(DbSession session, String componentUuid, List<ScannerReport.ComponentLink> links, List<ComponentLinkDto> previousLinks) {
            HashSet<String> linkType = new HashSet<String>();
            for (ScannerReport.ComponentLink link : links) {
                String type = this.convertType(link.getType());
                if (linkType.contains(type)) {
                    throw new IllegalArgumentException(String.format("Link of type '%s' has already been declared on component '%s'", type, componentUuid));
                }
                linkType.add(type);
                Optional<ComponentLinkDto> previousLink = previousLinks.stream().filter(input -> input != null && input.getType().equals(this.convertType(link.getType()))).findFirst();
                if (previousLink.isPresent()) {
                    previousLink.get().setHref(link.getHref());
                    PersistProjectLinksStep.this.dbClient.componentLinkDao().update(session, previousLink.get());
                    continue;
                }
                PersistProjectLinksStep.this.dbClient.componentLinkDao().insert(session, new ComponentLinkDto().setComponentUuid(componentUuid).setType(type).setName(PersistProjectLinksStep.this.i18n.message(Locale.ENGLISH, "project_links." + type, null, new Object[0])).setHref(link.getHref()));
            }
            for (ComponentLinkDto dto : previousLinks) {
                if (linkType.contains(dto.getType()) || !ComponentLinkDto.PROVIDED_TYPES.contains(dto.getType())) continue;
                PersistProjectLinksStep.this.dbClient.componentLinkDao().delete(session, dto.getId().longValue());
            }
        }

        private String convertType(ScannerReport.ComponentLink.ComponentLinkType reportType) {
            String type = (String)typesConverter.get(reportType);
            if (type != null) {
                return type;
            }
            throw new IllegalArgumentException(String.format("Unsupported type %s", reportType.name()));
        }
    }
}

