/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.issue.Rule;
import org.sonar.server.computation.task.projectanalysis.issue.RuleRepository;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRulesHolderImpl;
import org.sonar.server.computation.task.step.ComputationStep;

public class LoadQualityProfilesStep
implements ComputationStep {
    private final BatchReportReader batchReportReader;
    private final ActiveRulesHolderImpl activeRulesHolder;
    private final RuleRepository ruleRepository;

    public LoadQualityProfilesStep(BatchReportReader batchReportReader, ActiveRulesHolderImpl activeRulesHolder, RuleRepository ruleRepository) {
        this.batchReportReader = batchReportReader;
        this.activeRulesHolder = activeRulesHolder;
        this.ruleRepository = ruleRepository;
    }

    @Override
    public void execute() {
        ArrayList<ActiveRule> activeRules = new ArrayList<ActiveRule>();
        try (CloseableIterator<ScannerReport.ActiveRule> batchActiveRules = this.batchReportReader.readActiveRules();){
            while (batchActiveRules.hasNext()) {
                ScannerReport.ActiveRule scannerReportActiveRule = (ScannerReport.ActiveRule)batchActiveRules.next();
                Optional<Rule> rule = this.ruleRepository.findByKey(RuleKey.of((String)scannerReportActiveRule.getRuleRepository(), (String)scannerReportActiveRule.getRuleKey()));
                if (!rule.isPresent() || ((Rule)rule.get()).getStatus() == RuleStatus.REMOVED) continue;
                ActiveRule activeRule = LoadQualityProfilesStep.convert(scannerReportActiveRule, (Rule)rule.get());
                activeRules.add(activeRule);
            }
        }
        this.activeRulesHolder.set(activeRules);
    }

    @Override
    public String getDescription() {
        return "Load quality profiles";
    }

    private static ActiveRule convert(ScannerReport.ActiveRule input, Rule rule) {
        RuleKey key = RuleKey.of((String)input.getRuleRepository(), (String)input.getRuleKey());
        HashMap<String, String> params = new HashMap<String, String>(input.getParamsByKey());
        return new ActiveRule(key, input.getSeverity().name(), params, input.getCreatedAt(), rule.getPluginKey());
    }
}

