/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.server.computation.task.projectanalysis.qualitygate.MutableQualityGateHolder;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGate;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateService;
import org.sonar.server.computation.task.step.ComputationStep;

public class LoadQualityGateStep
implements ComputationStep {
    private static final Logger LOGGER = Loggers.get(LoadQualityGateStep.class);
    private static final String PROPERTY_QUALITY_GATE = "sonar.qualitygate";
    private final ConfigurationRepository configRepository;
    private final QualityGateService qualityGateService;
    private final MutableQualityGateHolder qualityGateHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public LoadQualityGateStep(ConfigurationRepository settingsRepository, QualityGateService qualityGateService, MutableQualityGateHolder qualityGateHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.configRepository = settingsRepository;
        this.qualityGateService = qualityGateService;
        this.qualityGateHolder = qualityGateHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void execute() {
        if (this.analysisMetadataHolder.isShortLivingBranch()) {
            Optional<QualityGate> qualityGate = this.qualityGateService.findById(-1963456987L);
            if (!qualityGate.isPresent()) {
                throw new IllegalStateException("Failed to retrieve hardcoded short living branch Quality Gate");
            }
            this.qualityGateHolder.setQualityGate((QualityGate)qualityGate.get());
            return;
        }
        Configuration config = this.configRepository.getConfiguration();
        String qualityGateSetting = config.get(PROPERTY_QUALITY_GATE).orElse(null);
        if (StringUtils.isBlank((String)qualityGateSetting)) {
            LOGGER.debug("No quality gate is configured");
            this.qualityGateHolder.setNoQualityGate();
            return;
        }
        try {
            long qualityGateId = Long.parseLong(qualityGateSetting);
            Optional<QualityGate> qualityGate = this.qualityGateService.findById(qualityGateId);
            if (qualityGate.isPresent()) {
                this.qualityGateHolder.setQualityGate((QualityGate)qualityGate.get());
            } else {
                this.qualityGateHolder.setNoQualityGate();
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("Unsupported value (%s) in property %s", qualityGateSetting, PROPERTY_QUALITY_GATE), e);
        }
    }

    @Override
    public String getDescription() {
        return "Load Quality gate";
    }
}

