/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import javax.annotation.CheckForNull;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.source.LineReader;

public class ScmLineReader
implements LineReader {
    private final ScmInfo scmReport;
    @CheckForNull
    private Changeset latestChange;

    public ScmLineReader(ScmInfo scmReport) {
        this.scmReport = scmReport;
    }

    @Override
    public void read(DbFileSources.Line.Builder lineBuilder) {
        Changeset changeset = this.scmReport.getChangesetForLine(lineBuilder.getLine());
        String author = changeset.getAuthor();
        if (author != null) {
            lineBuilder.setScmAuthor(author);
        }
        lineBuilder.setScmRevision(changeset.getRevision());
        lineBuilder.setScmDate(changeset.getDate());
        this.updateLatestChange(changeset);
    }

    private void updateLatestChange(Changeset newChangeSet) {
        if (this.latestChange == null) {
            this.latestChange = newChangeSet;
        } else {
            long latestChangeDate;
            long newChangesetDate = newChangeSet.getDate();
            if (newChangesetDate > (latestChangeDate = this.latestChange.getDate())) {
                this.latestChange = newChangeSet;
            }
        }
    }

    @CheckForNull
    public Changeset getLatestChange() {
        return this.latestChange;
    }
}

