/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitymodel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.rules.RuleType;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.formula.counter.RatingValue;
import org.sonar.server.computation.task.projectanalysis.issue.ComponentIssuesRepository;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.RatingGrid;

public class ReliabilityAndSecurityRatingMeasuresVisitor
extends PathAwareVisitorAdapter<Counter> {
    private static final Map<String, RatingGrid.Rating> RATING_BY_SEVERITY = ImmutableMap.of((Object)"BLOCKER", (Object)((Object)RatingGrid.Rating.E), (Object)"CRITICAL", (Object)((Object)RatingGrid.Rating.D), (Object)"MAJOR", (Object)((Object)RatingGrid.Rating.C), (Object)"MINOR", (Object)((Object)RatingGrid.Rating.B), (Object)"INFO", (Object)((Object)RatingGrid.Rating.A));
    private final MeasureRepository measureRepository;
    private final ComponentIssuesRepository componentIssuesRepository;
    private final Metric reliabilityRatingMetric;
    private final Metric securityRatingMetric;
    private final Map<String, Metric> metricsByKey;

    public ReliabilityAndSecurityRatingMeasuresVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, ComponentIssuesRepository componentIssuesRepository) {
        super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER, CounterFactory.INSTANCE);
        this.measureRepository = measureRepository;
        this.componentIssuesRepository = componentIssuesRepository;
        this.reliabilityRatingMetric = metricRepository.getByKey("reliability_rating");
        this.securityRatingMetric = metricRepository.getByKey("security_rating");
        this.metricsByKey = ImmutableMap.of((Object)"reliability_rating", (Object)this.reliabilityRatingMetric, (Object)"security_rating", (Object)this.securityRatingMetric);
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(project, path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(directory, path);
    }

    @Override
    public void visitModule(Component module, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(module, path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(file, path);
    }

    private void computeAndSaveMeasures(Component component, PathAwareVisitor.Path<Counter> path) {
        this.processIssues(component, path);
        path.current().ratingValueByMetric.entrySet().forEach(entry -> this.measureRepository.add(component, this.metricsByKey.get(entry.getKey()), ReliabilityAndSecurityRatingMeasuresVisitor.createRatingMeasure(((RatingValue)entry.getValue()).getValue())));
        ReliabilityAndSecurityRatingMeasuresVisitor.addToParent(path);
    }

    private void processIssues(Component component, PathAwareVisitor.Path<Counter> path) {
        this.componentIssuesRepository.getIssues(component).stream().filter(issue -> issue.resolution() == null).filter(issue -> issue.type().equals((Object)RuleType.BUG) || issue.type().equals((Object)RuleType.VULNERABILITY)).forEach(path.current()::processIssue);
    }

    private static void addToParent(PathAwareVisitor.Path<Counter> path) {
        if (!path.isRoot()) {
            path.parent().add(path.current());
        }
    }

    private static Measure createRatingMeasure(RatingGrid.Rating rating) {
        return Measure.newMeasureBuilder().create(rating.getIndex(), rating.name());
    }

    private static final class CounterFactory
    extends PathAwareVisitorAdapter.SimpleStackElementFactory<Counter> {
        public static final CounterFactory INSTANCE = new CounterFactory();

        private CounterFactory() {
        }

        @Override
        public Counter createForAny(Component component) {
            return new Counter();
        }
    }

    static final class Counter {
        private Map<String, RatingValue> ratingValueByMetric = ImmutableMap.of((Object)"reliability_rating", (Object)new RatingValue(), (Object)"security_rating", (Object)new RatingValue());

        private Counter() {
        }

        void add(Counter otherCounter) {
            this.ratingValueByMetric.entrySet().forEach(e -> ((RatingValue)e.getValue()).increment(otherCounter.ratingValueByMetric.get(e.getKey())));
        }

        void processIssue(Issue issue) {
            RatingGrid.Rating rating = (RatingGrid.Rating)((Object)RATING_BY_SEVERITY.get(issue.severity()));
            if (issue.type().equals((Object)RuleType.BUG)) {
                this.ratingValueByMetric.get("reliability_rating").increment(rating);
            } else if (issue.type().equals((Object)RuleType.VULNERABILITY)) {
                this.ratingValueByMetric.get("security_rating").increment(rating);
            }
        }
    }
}

