/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitygate;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.api.i18n.I18n;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;
import org.sonar.core.timemachine.Periods;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;
import org.sonar.server.computation.task.projectanalysis.qualitygate.Condition;
import org.sonar.server.computation.task.projectanalysis.qualitygate.EvaluationResult;
import org.sonar.server.computation.task.projectanalysis.qualitygate.EvaluationResultTextConverter;

public final class EvaluationResultTextConverterImpl
implements EvaluationResultTextConverter {
    private static final String VARIATION_METRIC_PREFIX = "new_";
    private static final String VARIATION = "variation";
    private static final Map<Condition.Operator, String> OPERATOR_LABELS = ImmutableMap.of((Object)((Object)Condition.Operator.EQUALS), (Object)"=", (Object)((Object)Condition.Operator.NOT_EQUALS), (Object)"!=", (Object)((Object)Condition.Operator.GREATER_THAN), (Object)">", (Object)((Object)Condition.Operator.LESS_THAN), (Object)"<");
    private final I18n i18n;
    private final Durations durations;
    private final Periods periods;
    private final PeriodHolder periodHolder;

    public EvaluationResultTextConverterImpl(I18n i18n, Durations durations, Periods periods, PeriodHolder periodHolder) {
        this.i18n = i18n;
        this.durations = durations;
        this.periods = periods;
        this.periodHolder = periodHolder;
    }

    @Override
    @CheckForNull
    public String asText(Condition condition, EvaluationResult evaluationResult) {
        Objects.requireNonNull(condition);
        if (evaluationResult.getLevel() == Measure.Level.OK) {
            return null;
        }
        return this.getAlertLabel(condition, evaluationResult.getLevel());
    }

    private String getAlertLabel(Condition condition, Measure.Level level) {
        boolean hasPeriod = condition.hasPeriod();
        String metric = this.i18n.message(Locale.ENGLISH, "metric." + condition.getMetric().getKey() + ".name", condition.getMetric().getName(), new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(metric);
        if (hasPeriod && !condition.getMetric().getKey().startsWith(VARIATION_METRIC_PREFIX)) {
            String variation = this.i18n.message(Locale.ENGLISH, VARIATION, VARIATION, new Object[0]).toLowerCase(Locale.ENGLISH);
            stringBuilder.append(" ").append(variation);
        }
        stringBuilder.append(" ").append(OPERATOR_LABELS.get((Object)condition.getOperator())).append(" ").append(this.alertValue(condition, level));
        if (hasPeriod) {
            Period period = this.periodHolder.getPeriod();
            stringBuilder.append(" ").append(this.periods.label(period.getMode(), period.getModeParameter(), DateUtils.longToDate((Long)period.getSnapshotDate())));
        }
        return stringBuilder.toString();
    }

    private String alertValue(Condition condition, Measure.Level level) {
        String value;
        String string = value = level == Measure.Level.ERROR ? condition.getErrorThreshold() : condition.getWarningThreshold();
        if (condition.getMetric().getType() == Metric.MetricType.WORK_DUR) {
            return this.formatDuration(value);
        }
        return value;
    }

    private String formatDuration(String value) {
        return this.durations.format(Duration.create((long)Long.parseLong(value)));
    }
}

