/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;

public class ComponentsWithUnprocessedIssues {
    @CheckForNull
    private Set<String> uuids;

    public void setUuids(Set<String> uuids) {
        Objects.requireNonNull(uuids, "Uuids cannot be null");
        Preconditions.checkState((this.uuids == null ? 1 : 0) != 0, (Object)"Uuids have already been initialized");
        this.uuids = new HashSet<String>(uuids);
    }

    public void remove(String uuid) {
        this.checkIssuesAreInitialized();
        this.uuids.remove(uuid);
    }

    public Set<String> getUuids() {
        this.checkIssuesAreInitialized();
        return this.uuids;
    }

    private void checkIssuesAreInitialized() {
        Preconditions.checkState((this.uuids != null ? 1 : 0) != 0, (Object)"Uuids have not been initialized yet");
    }
}

