/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.MutableComponentIssuesRepository;

public class ComponentIssuesRepositoryImpl
implements MutableComponentIssuesRepository {
    @CheckForNull
    private List<DefaultIssue> issues;
    @CheckForNull
    private Component component;

    @Override
    public void setIssues(Component component, List<DefaultIssue> issues) {
        this.issues = Objects.requireNonNull(issues, "issues cannot be null");
        this.component = Objects.requireNonNull(component, "component cannot be null");
    }

    @Override
    public List<DefaultIssue> getIssues(Component component) {
        Preconditions.checkState((this.component != null && this.issues != null ? 1 : 0) != 0, (Object)"Issues have not been initialized");
        Preconditions.checkArgument((boolean)component.equals(this.component), (String)"Only issues from component '%s' are available, but wanted component is '%s'.", (Object[])new Object[]{this.component.getReportAttributes().getRef(), component.getReportAttributes().getRef()});
        return this.issues;
    }
}

