/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula.counter;

import com.google.common.base.Optional;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.counter.SumCounter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public class IntSumCounter
implements SumCounter<Integer, IntSumCounter> {
    private final String metricKey;
    @CheckForNull
    private final Integer defaultInputValue;
    private int value = 0;
    private boolean initialized = false;

    public IntSumCounter(String metricKey) {
        this(metricKey, null);
    }

    public IntSumCounter(String metricKey, @Nullable Integer defaultInputValue) {
        this.metricKey = Objects.requireNonNull(metricKey, "metricKey can not be null");
        this.defaultInputValue = defaultInputValue;
    }

    @Override
    public void aggregate(IntSumCounter counter) {
        if (counter.getValue().isPresent()) {
            this.addValue((Integer)counter.getValue().get());
        }
    }

    @Override
    public void initialize(CounterInitializationContext context) {
        Optional<Measure> measureOptional = context.getMeasure(this.metricKey);
        if (measureOptional.isPresent()) {
            this.addValue(((Measure)measureOptional.get()).getIntValue());
        } else if (this.defaultInputValue != null) {
            this.addValue(this.defaultInputValue);
        }
    }

    private void addValue(int newValue) {
        this.initialized = true;
        this.value += newValue;
    }

    @Override
    public Optional<Integer> getValue() {
        if (this.initialized) {
            return Optional.of((Object)this.value);
        }
        return Optional.absent();
    }
}

