/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.filemove;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sonar.server.computation.task.projectanalysis.filemove.FileSimilarity;

final class ScoreMatrix {
    private final Set<String> dbFileKeys;
    private final Map<String, FileSimilarity.File> reportFileSourcesByKey;
    private final int[][] scores;
    private final int maxScore;

    public ScoreMatrix(Set<String> dbFileKeys, Map<String, FileSimilarity.File> reportFileSourcesByKey, int[][] scores, int maxScore) {
        this.dbFileKeys = dbFileKeys;
        this.reportFileSourcesByKey = reportFileSourcesByKey;
        this.scores = scores;
        this.maxScore = maxScore;
    }

    public void accept(ScoreMatrixVisitor visitor) {
        int dbFileIndex = 0;
        for (String dbFileKey : this.dbFileKeys) {
            int reportFileIndex = 0;
            for (Map.Entry<String, FileSimilarity.File> reportFileSourceAndKey : this.reportFileSourcesByKey.entrySet()) {
                int score = this.scores[dbFileIndex][reportFileIndex];
                visitor.visit(dbFileKey, reportFileSourceAndKey.getKey(), score);
                ++reportFileIndex;
            }
            ++dbFileIndex;
        }
    }

    public String toCsv(final char separator) {
        final StringBuilder res = new StringBuilder();
        res.append(separator);
        for (Map.Entry<String, FileSimilarity.File> reportEntry : this.reportFileSourcesByKey.entrySet()) {
            res.append(reportEntry.getKey()).append(separator);
        }
        this.accept(new ScoreMatrixVisitor(){
            private String previousDbFileKey = null;

            @Override
            public void visit(String dbFileKey, String reportFileKey, int score) {
                if (!Objects.equals(this.previousDbFileKey, dbFileKey)) {
                    res.append('\n').append(dbFileKey).append(separator);
                    this.previousDbFileKey = dbFileKey;
                }
                res.append(score).append(separator);
            }
        });
        return res.toString();
    }

    public int getMaxScore() {
        return this.maxScore;
    }

    @FunctionalInterface
    public static interface ScoreMatrixVisitor {
        public void visit(String var1, String var2, int var3);
    }
}

