/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.event.Event;
import org.sonar.server.computation.task.projectanalysis.event.EventRepository;

public class EventRepositoryImpl
implements EventRepository {
    private final Multimap<Integer, Event> events = HashMultimap.create();

    @Override
    public void add(Component component, Event event) {
        Preconditions.checkArgument((component.getType() == Component.Type.PROJECT ? 1 : 0) != 0, (Object)"Component must be of type PROJECT");
        this.events.put((Object)component.getReportAttributes().getRef(), (Object)Objects.requireNonNull(event));
    }

    @Override
    public Iterable<Event> getEvents(Component component) {
        return this.events.get((Object)component.getReportAttributes().getRef());
    }
}

