/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ViewAttributes {
    private final Type type;

    public ViewAttributes(Type type) {
        this.type = Objects.requireNonNull(type, "Type cannot be null");
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "viewAttributes{type='" + (Object)((Object)this.type) + '\'' + '}';
    }

    public static enum Type {
        PORTFOLIO("VW"),
        APPLICATION("APP");

        private final String qualifier;

        private Type(String qualifier) {
            this.qualifier = qualifier;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public static Type fromQualifier(String qualifier) {
            return Arrays.stream(Type.values()).filter(type -> type.getQualifier().equals(qualifier)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Qualifier '%s' is not supported", qualifier)));
        }
    }
}

