/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;

final class DequeBasedPath<T>
implements PathAwareVisitor.Path<T>,
Iterable<PathAwareVisitor.PathElement<T>> {
    private final Deque<PathAwareVisitor.PathElement<T>> deque = new ArrayDeque<PathAwareVisitor.PathElement<T>>();

    DequeBasedPath() {
    }

    @Override
    public T current() {
        return this.deque.getFirst().getElement();
    }

    @Override
    public T parent() {
        Iterator<PathAwareVisitor.PathElement<T>> iterator = this.deque.iterator();
        if (iterator.hasNext()) {
            iterator.next();
            if (iterator.hasNext()) {
                return iterator.next().getElement();
            }
        }
        throw new NoSuchElementException("Path is either empty or has only one element. There is no parent");
    }

    @Override
    public boolean isRoot() {
        return this.deque.size() == 1;
    }

    @Override
    public T root() {
        return this.deque.getLast().getElement();
    }

    @Override
    public Iterator<PathAwareVisitor.PathElement<T>> iterator() {
        return this.deque.iterator();
    }

    @Override
    public Iterable<PathAwareVisitor.PathElement<T>> getCurrentPath() {
        return this;
    }

    public void add(PathAwareVisitor.PathElement<T> pathElement) {
        this.deque.addFirst(pathElement);
    }

    public PathAwareVisitor.PathElement<T> pop() {
        return this.deque.pop();
    }
}

