/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.component.SnapshotDto;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.analysis.Project;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentImpl;
import org.sonar.server.computation.task.projectanalysis.component.ComponentKeyGenerator;
import org.sonar.server.computation.task.projectanalysis.component.FileAttributes;
import org.sonar.server.computation.task.projectanalysis.component.ReportAttributes;

public class ComponentTreeBuilder {
    private static final String DEFAULT_PROJECT_VERSION = "not provided";
    private final ComponentKeyGenerator keyGenerator;
    private final ComponentKeyGenerator publicKeyGenerator;
    private final Function<String, String> uuidSupplier;
    private final Function<Integer, ScannerReport.Component> scannerComponentSupplier;
    private final Project project;
    @Nullable
    private final SnapshotDto baseAnalysis;

    public ComponentTreeBuilder(ComponentKeyGenerator keyGenerator, ComponentKeyGenerator publicKeyGenerator, Function<String, String> uuidSupplier, Function<Integer, ScannerReport.Component> scannerComponentSupplier, Project project, @Nullable SnapshotDto baseAnalysis) {
        this.keyGenerator = keyGenerator;
        this.publicKeyGenerator = publicKeyGenerator;
        this.uuidSupplier = uuidSupplier;
        this.scannerComponentSupplier = scannerComponentSupplier;
        this.project = project;
        this.baseAnalysis = baseAnalysis;
    }

    public Component buildProject(ScannerReport.Component project) {
        return this.buildComponent(project, project);
    }

    private List<Component> buildChildren(ScannerReport.Component component, ScannerReport.Component parentModule) {
        return component.getChildRefList().stream().map(this.scannerComponentSupplier::apply).map(c -> this.buildComponent((ScannerReport.Component)c, parentModule)).collect(Collectors.toList());
    }

    private ComponentImpl buildComponent(ScannerReport.Component component, ScannerReport.Component closestModule) {
        switch (component.getType()) {
            case PROJECT: {
                String projectKey = this.keyGenerator.generateKey(component, null);
                String uuid = this.uuidSupplier.apply(projectKey);
                String projectPublicKey = this.publicKeyGenerator.generateKey(component, null);
                return ComponentImpl.builder(Component.Type.PROJECT).setUuid(uuid).setKey(projectKey).setPublicKey(projectPublicKey).setName(this.nameOfProject(component)).setStatus(ComponentTreeBuilder.convertStatus(component.getStatus())).setDescription(StringUtils.trimToNull((String)component.getDescription())).setReportAttributes(ComponentTreeBuilder.createAttributesBuilder(component).setVersion(this.createProjectVersion(component)).build()).addChildren(this.buildChildren(component, component)).build();
            }
            case MODULE: {
                String moduleKey = this.keyGenerator.generateKey(component, null);
                String modulePublicKey = this.publicKeyGenerator.generateKey(component, null);
                return ComponentImpl.builder(Component.Type.MODULE).setUuid(this.uuidSupplier.apply(moduleKey)).setKey(moduleKey).setPublicKey(modulePublicKey).setName(ComponentTreeBuilder.nameOfOthers(component, modulePublicKey)).setStatus(ComponentTreeBuilder.convertStatus(component.getStatus())).setDescription(StringUtils.trimToNull((String)component.getDescription())).setReportAttributes(ComponentTreeBuilder.createAttributesBuilder(component).build()).addChildren(this.buildChildren(component, component)).build();
            }
            case DIRECTORY: 
            case FILE: {
                String key = this.keyGenerator.generateKey(closestModule, component);
                String publicKey = this.publicKeyGenerator.generateKey(closestModule, component);
                return ComponentImpl.builder(ComponentTreeBuilder.convertDirOrFileType(component.getType())).setUuid(this.uuidSupplier.apply(key)).setKey(key).setPublicKey(publicKey).setName(ComponentTreeBuilder.nameOfOthers(component, publicKey)).setStatus(ComponentTreeBuilder.convertStatus(component.getStatus())).setDescription(StringUtils.trimToNull((String)component.getDescription())).setReportAttributes(ComponentTreeBuilder.createAttributesBuilder(component).build()).setFileAttributes(ComponentTreeBuilder.createFileAttributes(component)).addChildren(this.buildChildren(component, closestModule)).build();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported component type '%s'", component.getType()));
    }

    private static Component.Status convertStatus(ScannerReport.Component.FileStatus status) {
        switch (status) {
            case ADDED: {
                return Component.Status.ADDED;
            }
            case SAME: {
                return Component.Status.SAME;
            }
            case CHANGED: {
                return Component.Status.CHANGED;
            }
            case UNAVAILABLE: {
                return Component.Status.UNAVAILABLE;
            }
        }
        throw new IllegalArgumentException("Unsupported ComponentType value " + status);
    }

    private String nameOfProject(ScannerReport.Component component) {
        String name = StringUtils.trimToNull((String)component.getName());
        if (name != null) {
            return name;
        }
        return this.project.getName();
    }

    private static String nameOfOthers(ScannerReport.Component reportComponent, String defaultName) {
        String name = StringUtils.trimToNull((String)reportComponent.getName());
        return name == null ? defaultName : name;
    }

    private String createProjectVersion(ScannerReport.Component component) {
        String version = StringUtils.trimToNull((String)component.getVersion());
        if (version != null) {
            return version;
        }
        if (this.baseAnalysis != null) {
            return (String)MoreObjects.firstNonNull((Object)this.baseAnalysis.getVersion(), (Object)DEFAULT_PROJECT_VERSION);
        }
        return DEFAULT_PROJECT_VERSION;
    }

    private static ReportAttributes.Builder createAttributesBuilder(ScannerReport.Component component) {
        return ReportAttributes.newBuilder(component.getRef()).setVersion(StringUtils.trimToNull((String)component.getVersion())).setPath(StringUtils.trimToNull((String)component.getPath()));
    }

    @CheckForNull
    private static FileAttributes createFileAttributes(ScannerReport.Component component) {
        if (component.getType() != ScannerReport.Component.ComponentType.FILE) {
            return null;
        }
        Preconditions.checkArgument((component.getLines() > 0 ? 1 : 0) != 0, (String)"File '%s' has no line", (Object[])new Object[]{component.getPath()});
        return new FileAttributes(component.getIsTest(), StringUtils.trimToNull((String)component.getLanguage()), component.getLines());
    }

    private static Component.Type convertDirOrFileType(ScannerReport.Component.ComponentType type) {
        switch (type) {
            case DIRECTORY: {
                return Component.Type.DIRECTORY;
            }
            case FILE: {
                return Component.Type.FILE;
            }
        }
        throw new IllegalArgumentException("Unsupported ComponentType value " + type);
    }
}

