/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.server.computation.task.projectanalysis.component.FileAttributes;
import org.sonar.server.computation.task.projectanalysis.component.ProjectViewAttributes;
import org.sonar.server.computation.task.projectanalysis.component.ReportAttributes;
import org.sonar.server.computation.task.projectanalysis.component.SubViewAttributes;
import org.sonar.server.computation.task.projectanalysis.component.ViewAttributes;

public interface Component {
    public Type getType();

    public Status getStatus();

    public String getUuid();

    public String getKey();

    public String getPublicKey();

    public String getName();

    @CheckForNull
    public String getDescription();

    public List<Component> getChildren();

    public ReportAttributes getReportAttributes();

    public FileAttributes getFileAttributes();

    public ProjectViewAttributes getProjectViewAttributes();

    public SubViewAttributes getSubViewAttributes();

    public ViewAttributes getViewAttributes();

    public static enum Status {
        UNAVAILABLE,
        SAME,
        CHANGED,
        ADDED;

    }

    public static enum Type {
        PROJECT(0),
        MODULE(1),
        DIRECTORY(2),
        FILE(3),
        VIEW(0),
        SUBVIEW(1),
        PROJECT_VIEW(2);

        private static final Set<Type> REPORT_TYPES;
        private static final Set<Type> VIEWS_TYPES;
        private final int depth;

        private Type(int depth) {
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isDeeperThan(Type otherType) {
            return this.getDepth() > otherType.getDepth();
        }

        public boolean isHigherThan(Type otherType) {
            return this.getDepth() < otherType.getDepth();
        }

        public boolean isReportType() {
            return REPORT_TYPES.contains((Object)this);
        }

        public boolean isViewsType() {
            return VIEWS_TYPES.contains((Object)this);
        }

        static {
            REPORT_TYPES = EnumSet.of(PROJECT, MODULE, DIRECTORY, FILE);
            VIEWS_TYPES = EnumSet.of(VIEW, SUBVIEW, PROJECT_VIEW);
        }
    }
}

