/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.component.BranchType;
import org.sonar.server.computation.task.projectanalysis.analysis.Analysis;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.analysis.MutableAnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Organization;
import org.sonar.server.computation.task.projectanalysis.analysis.Project;
import org.sonar.server.computation.task.projectanalysis.analysis.ScannerPlugin;
import org.sonar.server.computation.util.InitializedProperty;
import org.sonar.server.qualityprofile.QualityProfile;

public class AnalysisMetadataHolderImpl
implements MutableAnalysisMetadataHolder {
    private static final String BRANCH_NOT_SET = "Branch has not been set";
    private final InitializedProperty<Organization> organization = new InitializedProperty();
    private final InitializedProperty<String> uuid = new InitializedProperty();
    private final InitializedProperty<Long> analysisDate = new InitializedProperty();
    private final InitializedProperty<Analysis> baseProjectSnapshot = new InitializedProperty();
    private final InitializedProperty<Boolean> crossProjectDuplicationEnabled = new InitializedProperty();
    private final InitializedProperty<Branch> branch = new InitializedProperty();
    private final InitializedProperty<Project> project = new InitializedProperty();
    private final InitializedProperty<Integer> rootComponentRef = new InitializedProperty();
    private final InitializedProperty<Map<String, QualityProfile>> qProfilesPerLanguage = new InitializedProperty();
    private final InitializedProperty<Map<String, ScannerPlugin>> pluginsByKey = new InitializedProperty();

    @Override
    public MutableAnalysisMetadataHolder setOrganization(Organization organization) {
        Preconditions.checkState((!this.organization.isInitialized() ? 1 : 0) != 0, (Object)"Organization has already been set");
        Objects.requireNonNull(organization, "Organization can't be null");
        this.organization.setProperty(organization);
        return this;
    }

    @Override
    public Organization getOrganization() {
        Preconditions.checkState((boolean)this.organization.isInitialized(), (Object)"Organization has not been set");
        return this.organization.getProperty();
    }

    @Override
    public MutableAnalysisMetadataHolder setUuid(String s) {
        Preconditions.checkState((!this.uuid.isInitialized() ? 1 : 0) != 0, (Object)"Analysis uuid has already been set");
        Objects.requireNonNull(s, "Analysis uuid can't be null");
        this.uuid.setProperty(s);
        return this;
    }

    @Override
    public String getUuid() {
        Preconditions.checkState((boolean)this.uuid.isInitialized(), (Object)"Analysis uuid has not been set");
        return this.uuid.getProperty();
    }

    @Override
    public MutableAnalysisMetadataHolder setAnalysisDate(long date) {
        Preconditions.checkState((!this.analysisDate.isInitialized() ? 1 : 0) != 0, (Object)"Analysis date has already been set");
        this.analysisDate.setProperty(date);
        return this;
    }

    @Override
    public long getAnalysisDate() {
        Preconditions.checkState((boolean)this.analysisDate.isInitialized(), (Object)"Analysis date has not been set");
        return this.analysisDate.getProperty();
    }

    @Override
    public boolean hasAnalysisDateBeenSet() {
        return this.analysisDate.isInitialized();
    }

    @Override
    public boolean isFirstAnalysis() {
        return this.getBaseAnalysis() == null;
    }

    @Override
    public MutableAnalysisMetadataHolder setBaseAnalysis(@Nullable Analysis baseAnalysis) {
        Preconditions.checkState((!this.baseProjectSnapshot.isInitialized() ? 1 : 0) != 0, (Object)"Base project snapshot has already been set");
        this.baseProjectSnapshot.setProperty(baseAnalysis);
        return this;
    }

    @Override
    @CheckForNull
    public Analysis getBaseAnalysis() {
        Preconditions.checkState((boolean)this.baseProjectSnapshot.isInitialized(), (Object)"Base project snapshot has not been set");
        return this.baseProjectSnapshot.getProperty();
    }

    @Override
    public MutableAnalysisMetadataHolder setCrossProjectDuplicationEnabled(boolean isCrossProjectDuplicationEnabled) {
        Preconditions.checkState((!this.crossProjectDuplicationEnabled.isInitialized() ? 1 : 0) != 0, (Object)"Cross project duplication flag has already been set");
        this.crossProjectDuplicationEnabled.setProperty(isCrossProjectDuplicationEnabled);
        return this;
    }

    @Override
    public boolean isCrossProjectDuplicationEnabled() {
        Preconditions.checkState((boolean)this.crossProjectDuplicationEnabled.isInitialized(), (Object)"Cross project duplication flag has not been set");
        return this.crossProjectDuplicationEnabled.getProperty();
    }

    @Override
    public MutableAnalysisMetadataHolder setBranch(Branch branch) {
        Preconditions.checkState((!this.branch.isInitialized() ? 1 : 0) != 0, (Object)"Branch has already been set");
        this.branch.setProperty(branch);
        return this;
    }

    @Override
    public Branch getBranch() {
        Preconditions.checkState((boolean)this.branch.isInitialized(), (Object)BRANCH_NOT_SET);
        return this.branch.getProperty();
    }

    @Override
    public MutableAnalysisMetadataHolder setProject(Project project) {
        Preconditions.checkState((!this.project.isInitialized() ? 1 : 0) != 0, (Object)"Project has already been set");
        this.project.setProperty(project);
        return this;
    }

    @Override
    public Project getProject() {
        Preconditions.checkState((boolean)this.project.isInitialized(), (Object)"Project has not been set");
        return this.project.getProperty();
    }

    @Override
    public MutableAnalysisMetadataHolder setRootComponentRef(int rootComponentRef) {
        Preconditions.checkState((!this.rootComponentRef.isInitialized() ? 1 : 0) != 0, (Object)"Root component ref has already been set");
        this.rootComponentRef.setProperty(rootComponentRef);
        return this;
    }

    @Override
    public int getRootComponentRef() {
        Preconditions.checkState((boolean)this.rootComponentRef.isInitialized(), (Object)"Root component ref has not been set");
        return this.rootComponentRef.getProperty();
    }

    @Override
    public MutableAnalysisMetadataHolder setQProfilesByLanguage(Map<String, QualityProfile> qprofilesByLanguage) {
        Preconditions.checkState((!this.qProfilesPerLanguage.isInitialized() ? 1 : 0) != 0, (Object)"QProfiles by language has already been set");
        this.qProfilesPerLanguage.setProperty((Map<String, QualityProfile>)ImmutableMap.copyOf(qprofilesByLanguage));
        return this;
    }

    @Override
    public Map<String, QualityProfile> getQProfilesByLanguage() {
        Preconditions.checkState((boolean)this.qProfilesPerLanguage.isInitialized(), (Object)"QProfiles by language has not been set");
        return this.qProfilesPerLanguage.getProperty();
    }

    @Override
    public MutableAnalysisMetadataHolder setScannerPluginsByKey(Map<String, ScannerPlugin> pluginsByKey) {
        Preconditions.checkState((!this.pluginsByKey.isInitialized() ? 1 : 0) != 0, (Object)"Plugins by key has already been set");
        this.pluginsByKey.setProperty((Map<String, ScannerPlugin>)ImmutableMap.copyOf(pluginsByKey));
        return this;
    }

    @Override
    public Map<String, ScannerPlugin> getScannerPluginsByKey() {
        Preconditions.checkState((boolean)this.pluginsByKey.isInitialized(), (Object)"Plugins by key has not been set");
        return this.pluginsByKey.getProperty();
    }

    @Override
    public boolean isShortLivingBranch() {
        Preconditions.checkState((boolean)this.branch.isInitialized(), (Object)BRANCH_NOT_SET);
        Branch prop = this.branch.getProperty();
        return prop != null && prop.getType() == BranchType.SHORT;
    }

    @Override
    public boolean isLongLivingBranch() {
        Preconditions.checkState((boolean)this.branch.isInitialized(), (Object)BRANCH_NOT_SET);
        Branch prop = this.branch.getProperty();
        return prop != null && prop.getType() == BranchType.LONG;
    }
}

