/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import java.util.Arrays;

public enum SuggestionCategory {
    VIEW("VW"),
    SUBVIEW("SVW"),
    APP("APP"),
    PROJECT("TRK"),
    MODULE("BRC"),
    FILE("FIL"),
    UNIT_TEST_FILE("UTS");

    private final String qualifier;

    private SuggestionCategory(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getName() {
        return this.qualifier;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public static SuggestionCategory getByName(String name) {
        return Arrays.stream(SuggestionCategory.values()).filter(c -> c.getName().equals(name)).findAny().orElseThrow(() -> new IllegalStateException(String.format("Cannot find category for name '%s'.", name)));
    }
}

