/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.util.stream.MoreCollectors;

public class FilterParser {
    private static final String DOUBLE_QUOTES = "\"";
    private static final Splitter CRITERIA_SPLITTER = Splitter.on((Pattern)Pattern.compile(" and ", 2)).trimResults().omitEmptyStrings();
    private static final Splitter IN_VALUES_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final Pattern PATTERN = Pattern.compile("(\\w+)\\s*([<>]?[=]?)\\s*(.*)", 2);
    private static final Pattern PATTERN_HAVING_VALUES = Pattern.compile("(\\w+)\\s+(in)\\s+\\((.*)\\)", 2);

    private FilterParser() {
    }

    public static List<Criterion> parse(String filter) {
        return (List)StreamSupport.stream(CRITERIA_SPLITTER.split((CharSequence)filter).spliterator(), false).map(FilterParser::parseCriterion).collect(MoreCollectors.toList());
    }

    private static Criterion parseCriterion(String rawCriterion) {
        try {
            Criterion criterion = FilterParser.tryParsingCriterionHavingValues(rawCriterion);
            if (criterion != null) {
                return criterion;
            }
            criterion = FilterParser.tryParsingCriterionNotHavingValues(rawCriterion);
            if (criterion != null) {
                return criterion;
            }
            throw new IllegalArgumentException("Criterion is invalid");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot parse '%s' : %s", rawCriterion, e.getMessage()), e);
        }
    }

    @CheckForNull
    private static Criterion tryParsingCriterionNotHavingValues(String criterion) {
        Matcher matcher = PATTERN.matcher(criterion);
        if (!matcher.find()) {
            return null;
        }
        Criterion.Builder builder = new Criterion.Builder();
        builder.setKey(matcher.group(1));
        String operatorValue = matcher.group(2);
        String value = matcher.group(3);
        if (!Strings.isNullOrEmpty((String)operatorValue) && !Strings.isNullOrEmpty((String)value)) {
            builder.setOperator(Operator.getByValue(operatorValue));
            builder.setValue(FilterParser.sanitizeValue(value));
        }
        return builder.build();
    }

    @CheckForNull
    private static Criterion tryParsingCriterionHavingValues(String criterion) {
        Matcher matcher = PATTERN_HAVING_VALUES.matcher(criterion);
        if (!matcher.find()) {
            return null;
        }
        Criterion.Builder builder = new Criterion.Builder();
        builder.setKey(matcher.group(1));
        builder.setOperator(Operator.IN);
        builder.setValues(IN_VALUES_SPLITTER.splitToList((CharSequence)matcher.group(3)));
        return builder.build();
    }

    @CheckForNull
    private static String sanitizeValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (value.length() > 2 && value.startsWith(DOUBLE_QUOTES) && value.endsWith(DOUBLE_QUOTES)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static enum Operator {
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">="),
        EQ("="),
        IN("in");

        String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Operator getByValue(String value) {
            return Arrays.stream(Operator.values()).filter(operator -> operator.getValue().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown operator '%s'", value)));
        }
    }

    public static class Criterion {
        private final String key;
        private final Operator operator;
        private final String value;
        private final List<String> values;

        private Criterion(Builder builder) {
            this.key = builder.key;
            this.operator = builder.operator;
            this.value = builder.value;
            this.values = builder.values;
        }

        public String getKey() {
            return this.key;
        }

        @CheckForNull
        public Operator getOperator() {
            return this.operator;
        }

        @CheckForNull
        public String getValue() {
            return this.value;
        }

        public List<String> getValues() {
            return this.values;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String key;
            private Operator operator;
            private String value;
            private List<String> values = new ArrayList<String>();

            public Builder setKey(String key) {
                this.key = key;
                return this;
            }

            public Builder setOperator(@Nullable Operator operator) {
                this.operator = operator;
                return this;
            }

            public Builder setValue(@Nullable String value) {
                this.value = value;
                return this;
            }

            public Builder setValues(List<String> values) {
                this.values = Objects.requireNonNull(values, "Values cannot be null");
                return this;
            }

            public Criterion build() {
                return new Criterion(this);
            }
        }
    }
}

