/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;

public class IsQueueEmptyWs
implements WebService {
    public static final String API_ENDPOINT = "api/analysis_reports";
    private final IsQueueEmptyAction action;

    public IsQueueEmptyWs(DbClient dbClient) {
        this.action = new IsQueueEmptyAction(dbClient);
    }

    public void define(WebService.Context context) {
        WebService.NewController controller = context.createController(API_ENDPOINT).setDescription("Get details about Compute Engine tasks.");
        this.action.define(controller);
        controller.done();
    }

    static class IsQueueEmptyAction
    implements RequestHandler {
        private final DbClient dbClient;

        public IsQueueEmptyAction(DbClient dbClient) {
            this.dbClient = dbClient;
        }

        public void define(WebService.NewController controller) {
            controller.createAction("is_queue_empty").setDescription("Check if the queue of Compute Engine is empty").setResponseExample(this.getClass().getResource("is_queue_empty-example.txt")).setSince("5.1").setInternal(true).setHandler((RequestHandler)this);
        }

        public void handle(Request request, Response response) throws Exception {
            boolean isQueueEmpty = false;
            try (DbSession dbSession = this.dbClient.openSession(false);){
                isQueueEmpty = this.dbClient.ceQueueDao().selectAllInAscOrder(dbSession).isEmpty();
            }
            catch (Exception e) {
                Loggers.get(this.getClass()).error("Cannot select rows from ce_queue", (Throwable)e);
            }
            IOUtils.write((String)String.valueOf(isQueueEmpty), (OutputStream)response.stream().output(), (Charset)StandardCharsets.UTF_8);
        }
    }
}

