/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.scanner.protocol.Constants;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonar.server.batch.BatchWsAction;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;

public class IssuesAction
implements BatchWsAction {
    private static final String PARAM_KEY = "key";
    private static final String PARAM_BRANCH = "branch";
    private static final Splitter MODULE_PATH_SPLITTER = Splitter.on((char)'.').trimResults().omitEmptyStrings();
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public IssuesAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("issues").setDescription("Return open issues").setResponseExample(this.getClass().getResource("issues-example.proto")).setSince("5.1").setInternal(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setRequired(true).setDescription("Project, module or file key").setExampleValue((Object)"my_project");
        action.createParam(PARAM_BRANCH).setSince("6.6").setDescription("Branch key").setExampleValue((Object)"feature/my_branch");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, request);
            this.userSession.checkComponentPermission("user", component);
            Map<String, String> keysByUUid = this.keysByUUid(dbSession, component);
            ScannerInput.ServerIssue.Builder responseBuilder = ScannerInput.ServerIssue.newBuilder();
            response.stream().setMediaType("application/x-protobuf");
            OutputStream output = response.stream().output();
            ResultHandler handler = resultContext -> {
                IssueDto issue = (IssueDto)resultContext.getResultObject();
                IssuesAction.handleIssue(issue, responseBuilder, keysByUUid, output);
            };
            switch (component.scope()) {
                case "PRJ": {
                    this.dbClient.issueDao().scrollNonClosedByModuleOrProject(dbSession, component, handler);
                    return;
                }
                case "FIL": {
                    this.dbClient.issueDao().scrollNonClosedByComponentUuid(dbSession, component.uuid(), handler);
                    return;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Component of scope '%s' is not allowed", component.scope()));
                }
            }
        }
    }

    private static void handleIssue(IssueDto issue, ScannerInput.ServerIssue.Builder issueBuilder, Map<String, String> keysByUUid, OutputStream out) {
        issueBuilder.setKey(issue.getKey());
        String moduleUuid = IssuesAction.extractModuleUuid(issue);
        issueBuilder.setModuleKey(keysByUUid.get(moduleUuid));
        Protobuf.setNullable((Object)issue.getFilePath(), arg_0 -> ((ScannerInput.ServerIssue.Builder)issueBuilder).setPath(arg_0));
        issueBuilder.setRuleRepository(issue.getRuleRepo());
        issueBuilder.setRuleKey(issue.getRule());
        Protobuf.setNullable((Object)issue.getChecksum(), arg_0 -> ((ScannerInput.ServerIssue.Builder)issueBuilder).setChecksum(arg_0));
        Protobuf.setNullable((Object)issue.getAssignee(), arg_0 -> ((ScannerInput.ServerIssue.Builder)issueBuilder).setAssigneeLogin(arg_0));
        Protobuf.setNullable((Object)issue.getLine(), arg_0 -> ((ScannerInput.ServerIssue.Builder)issueBuilder).setLine(arg_0));
        Protobuf.setNullable((Object)issue.getMessage(), arg_0 -> ((ScannerInput.ServerIssue.Builder)issueBuilder).setMsg(arg_0));
        issueBuilder.setSeverity(Constants.Severity.valueOf((String)issue.getSeverity()));
        issueBuilder.setManualSeverity(issue.isManualSeverity());
        issueBuilder.setStatus(issue.getStatus());
        Protobuf.setNullable((Object)issue.getResolution(), arg_0 -> ((ScannerInput.ServerIssue.Builder)issueBuilder).setResolution(arg_0));
        issueBuilder.setType(RuleType.valueOf((int)issue.getType()).name());
        issueBuilder.setCreationDate(issue.getIssueCreationTime().longValue());
        try {
            issueBuilder.build().writeDelimitedTo(out);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to serialize issue", e);
        }
        issueBuilder.clear();
    }

    private static String extractModuleUuid(IssueDto issue) {
        List split = MODULE_PATH_SPLITTER.splitToList((CharSequence)issue.getModuleUuidPath());
        return (String)split.get(split.size() - 1);
    }

    private Map<String, String> keysByUUid(DbSession session, ComponentDto component) {
        HashMap keysByUUid = Maps.newHashMap();
        if ("PRJ".equals(component.scope())) {
            List modulesTree = this.dbClient.componentDao().selectDescendantModules(session, component.uuid());
            for (ComponentDto componentDto : modulesTree) {
                keysByUUid.put(componentDto.uuid(), componentDto.getKey());
            }
        } else {
            String moduleUuid = component.moduleUuid();
            Preconditions.checkArgument((moduleUuid != null ? 1 : 0) != 0, (String)"The component '%s' has no module uuid", (Object[])new Object[]{component.uuid()});
            ComponentDto module = this.dbClient.componentDao().selectOrFailByUuid(session, moduleUuid);
            keysByUUid.put(module.uuid(), module.getKey());
        }
        return keysByUUid;
    }

    private ComponentDto loadComponent(DbSession dbSession, Request request) {
        String componentKey = request.mandatoryParam(PARAM_KEY);
        String branch = request.param(PARAM_BRANCH);
        if (branch != null) {
            return this.componentFinder.getByKeyAndBranch(dbSession, componentKey, branch);
        }
        return this.componentFinder.getByKey(dbSession, componentKey);
    }
}

