/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.platform.Server;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.api.server.authentication.UnauthorizedException;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.authentication.AuthenticationError;
import org.sonar.server.authentication.AuthenticationFilter;
import org.sonar.server.authentication.IdentityProviderRepository;
import org.sonar.server.authentication.OAuth2ContextFactory;
import org.sonar.server.authentication.OAuth2Redirection;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;

public class OAuth2CallbackFilter
extends AuthenticationFilter {
    private final OAuth2ContextFactory oAuth2ContextFactory;
    private final AuthenticationEvent authenticationEvent;
    private final OAuth2Redirection oAuthRedirection;

    public OAuth2CallbackFilter(IdentityProviderRepository identityProviderRepository, OAuth2ContextFactory oAuth2ContextFactory, Server server, AuthenticationEvent authenticationEvent, OAuth2Redirection oAuthRedirection) {
        super(server, identityProviderRepository);
        this.oAuth2ContextFactory = oAuth2ContextFactory;
        this.authenticationEvent = authenticationEvent;
        this.oAuthRedirection = oAuthRedirection;
    }

    public ServletFilter.UrlPattern doGetPattern() {
        return ServletFilter.UrlPattern.create((String)"/oauth2/callback/*");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        IdentityProvider provider = this.resolveProviderOrHandleResponse(httpRequest, httpResponse, "/oauth2/callback/");
        if (provider != null) {
            this.handleProvider(httpRequest, (HttpServletResponse)response, provider);
        }
    }

    private void handleProvider(HttpServletRequest request, HttpServletResponse response, IdentityProvider provider) {
        try {
            if (provider instanceof OAuth2IdentityProvider) {
                this.handleOAuth2Provider(response, request, (OAuth2IdentityProvider)provider);
            } else {
                AuthenticationError.handleError(response, String.format("Not an OAuth2IdentityProvider: %s", provider.getClass()));
            }
        }
        catch (AuthenticationException e) {
            this.oAuthRedirection.delete(request, response);
            this.authenticationEvent.loginFailure(request, e);
            AuthenticationError.handleAuthenticationError(e, response, this.getContextPath());
        }
        catch (Exception e) {
            this.oAuthRedirection.delete(request, response);
            AuthenticationError.handleError(e, response, String.format("Fail to callback authentication with '%s'", provider.getKey()));
        }
    }

    private void handleOAuth2Provider(HttpServletResponse response, HttpServletRequest httpRequest, OAuth2IdentityProvider oAuth2Provider) {
        WrappedContext context = new WrappedContext(this.oAuth2ContextFactory.newCallback(httpRequest, response, oAuth2Provider));
        try {
            oAuth2Provider.callback((OAuth2IdentityProvider.CallbackContext)context);
        }
        catch (UnauthorizedException e) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.oauth2(oAuth2Provider)).setMessage(e.getMessage()).setPublicMessage(e.getMessage()).build();
        }
        if (!context.isAuthenticated()) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.oauth2(oAuth2Provider)).setMessage("Plugin did not call authenticate").build();
        }
        this.authenticationEvent.loginSuccess(httpRequest, context.getLogin(), AuthenticationEvent.Source.oauth2(oAuth2Provider));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private static final class WrappedContext
    implements OAuth2IdentityProvider.CallbackContext {
        private final OAuth2IdentityProvider.CallbackContext delegate;
        private boolean authenticated = false;
        @CheckForNull
        private String login;

        private WrappedContext(OAuth2IdentityProvider.CallbackContext delegate) {
            this.delegate = delegate;
        }

        public String getCallbackUrl() {
            return this.delegate.getCallbackUrl();
        }

        public HttpServletRequest getRequest() {
            return this.delegate.getRequest();
        }

        public HttpServletResponse getResponse() {
            return this.delegate.getResponse();
        }

        public void verifyCsrfState() {
            this.delegate.verifyCsrfState();
        }

        public void redirectToRequestedPage() {
            this.delegate.redirectToRequestedPage();
        }

        public void authenticate(UserIdentity userIdentity) {
            this.delegate.authenticate(userIdentity);
            this.authenticated = true;
            this.login = userIdentity.getLogin();
        }

        public boolean isAuthenticated() {
            return this.authenticated;
        }

        @CheckForNull
        public String getLogin() {
            return this.login;
        }
    }
}

